/*
 * Decompiled with CFR 0.152.
 */
package org.lable.oss.dynamicconfig.di;

import com.google.inject.Inject;
import javax.inject.Provider;
import javax.inject.Singleton;
import org.apache.commons.configuration.Configuration;
import org.apache.commons.configuration.HierarchicalConfiguration;
import org.lable.oss.dynamicconfig.core.ConfigurationException;
import org.lable.oss.dynamicconfig.core.ConfigurationManager;
import org.lable.oss.dynamicconfig.core.InitializedConfiguration;
import org.lable.oss.dynamicconfig.core.spi.HierarchicalConfigurationDeserializer;
import org.lable.oss.dynamicconfig.di.ConfigurationDefaults;
import org.lable.oss.dynamicconfig.di.ConfigurationSourceType;

@Singleton
public class ConfigurationProvider
implements Provider<Configuration> {
    final HierarchicalConfigurationDeserializer deserializer;
    HierarchicalConfiguration defaults;
    String sourceType;

    @Inject
    ConfigurationProvider(HierarchicalConfigurationDeserializer deserializer) {
        this.deserializer = deserializer;
    }

    @Inject(optional=true)
    public void setDefaults(@ConfigurationDefaults HierarchicalConfiguration defaults) {
        this.defaults = defaults;
    }

    @Inject(optional=true)
    public void setSourceType(@ConfigurationSourceType String sourceType) {
        this.sourceType = sourceType;
    }

    public Configuration get() {
        Configuration result;
        try {
            InitializedConfiguration ic = ConfigurationManager.configureFromProperties((String)this.sourceType, (HierarchicalConfiguration)this.defaults, (HierarchicalConfigurationDeserializer)this.deserializer);
            result = ic.getConfiguration();
        }
        catch (ConfigurationException e) {
            throw new RuntimeException(e);
        }
        return result;
    }
}

