/*
 * Decompiled with CFR 0.152.
 */
package org.lable.oss.dynamicconfig.di;

import com.google.inject.Inject;
import java.io.Closeable;
import javax.inject.Provider;
import javax.inject.Singleton;
import org.apache.commons.configuration.HierarchicalConfiguration;
import org.lable.oss.dynamicconfig.core.ConfigurationException;
import org.lable.oss.dynamicconfig.core.ConfigurationLoader;
import org.lable.oss.dynamicconfig.core.ConfigurationManager;
import org.lable.oss.dynamicconfig.core.spi.HierarchicalConfigurationDeserializer;
import org.lable.oss.dynamicconfig.di.ConfigurationDefaults;
import org.lable.oss.dynamicconfig.di.ConfigurationManagerCloser;
import org.lable.oss.dynamicconfig.di.ConfigurationSourceType;

@Singleton
public class ConfigurationManagerProvider
implements Provider<ConfigurationManager> {
    final HierarchicalConfigurationDeserializer deserializer;
    HierarchicalConfiguration defaults;
    String sourceType;
    ConfigurationManagerCloser closer;

    @Inject
    ConfigurationManagerProvider(HierarchicalConfigurationDeserializer deserializer) {
        this.deserializer = deserializer;
    }

    @Inject(optional=true)
    public void setDefaults(@ConfigurationDefaults HierarchicalConfiguration defaults) {
        this.defaults = defaults;
    }

    @Inject(optional=true)
    public void setSourceType(@ConfigurationSourceType String sourceType) {
        this.sourceType = sourceType;
    }

    @Inject(optional=true)
    public void setCloser(ConfigurationManagerCloser closer) {
        this.closer = closer;
    }

    public ConfigurationManager get() {
        try {
            ConfigurationManager configurationManager = ConfigurationLoader.configureFromProperties((String)this.sourceType, (HierarchicalConfiguration)this.defaults, (HierarchicalConfigurationDeserializer)this.deserializer);
            if (this.closer != null) {
                this.closer.register((Closeable)configurationManager);
            }
            return configurationManager;
        }
        catch (ConfigurationException e) {
            throw new RuntimeException(e);
        }
    }
}

