/*
 * Decompiled with CFR 0.152.
 */
package org.lable.oss.dynamicconfig.di;

import com.google.inject.AbstractModule;
import com.google.inject.Provides;
import com.google.inject.Singleton;
import java.util.Iterator;
import java.util.ServiceLoader;
import org.apache.commons.configuration.Configuration;
import org.lable.oss.dynamicconfig.core.ConfigurationException;
import org.lable.oss.dynamicconfig.core.ConfigurationManager;
import org.lable.oss.dynamicconfig.core.spi.HierarchicalConfigurationDeserializer;
import org.lable.oss.dynamicconfig.di.ConfigurationManagerProvider;
import org.lable.oss.dynamicconfig.di.ConfigurationProvider;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DynamicConfigModule
extends AbstractModule {
    private final Logger logger = LoggerFactory.getLogger(DynamicConfigModule.class);

    protected void configure() {
        this.bind(ConfigurationManager.class).toProvider(ConfigurationManagerProvider.class).in(Singleton.class);
        this.bind(Configuration.class).toProvider(ConfigurationProvider.class).in(Singleton.class);
    }

    @Provides
    @Singleton
    public HierarchicalConfigurationDeserializer provideDeserializer() throws ConfigurationException {
        ServiceLoader<HierarchicalConfigurationDeserializer> serviceLoader = ServiceLoader.load(HierarchicalConfigurationDeserializer.class);
        Iterator<HierarchicalConfigurationDeserializer> iterator = serviceLoader.iterator();
        if (!iterator.hasNext()) {
            throw new ConfigurationException("No HierarchicalConfigurationDeserializer found on the classpath. You may need to load a module containing a suitable deserializer.");
        }
        HierarchicalConfigurationDeserializer hierarchicalConfigurationDeserializer = iterator.next();
        this.logger.info("Found HierarchicalConfigurationDeserializer {}; providing it to the configuration system.", (Object)hierarchicalConfigurationDeserializer.getClass().getName());
        return hierarchicalConfigurationDeserializer;
    }
}

