/*
 * Decompiled with CFR 0.152.
 */
package net.jodah.failsafe.internal;

import net.jodah.failsafe.CircuitBreaker;
import net.jodah.failsafe.ExecutionContext;
import net.jodah.failsafe.internal.CircuitBreakerInternals;
import net.jodah.failsafe.internal.CircuitState;
import net.jodah.failsafe.internal.util.CircularBitSet;
import net.jodah.failsafe.util.Ratio;

public class HalfOpenState
extends CircuitState {
    private final CircuitBreaker breaker;
    private final CircuitBreakerInternals internals;

    public HalfOpenState(CircuitBreaker breaker, CircuitBreakerInternals internals) {
        this.breaker = breaker;
        this.internals = internals;
        this.setSuccessThreshold(breaker.getSuccessThreshold() != null ? breaker.getSuccessThreshold() : (breaker.getFailureThreshold() != null ? breaker.getFailureThreshold() : ONE_OF_ONE));
    }

    @Override
    public boolean allowsExecution() {
        return this.internals.getCurrentExecutions() < this.maxConcurrentExecutions();
    }

    @Override
    public CircuitBreaker.State getInternals() {
        return CircuitBreaker.State.HALF_OPEN;
    }

    @Override
    public synchronized void recordFailure(ExecutionContext context) {
        this.bitSet.setNext(false);
        this.checkThreshold();
    }

    @Override
    public synchronized void recordSuccess() {
        this.bitSet.setNext(true);
        this.checkThreshold();
    }

    @Override
    public void setFailureThreshold(Ratio threshold) {
        if (this.breaker.getSuccessThreshold() == null) {
            this.bitSet = new CircularBitSet(threshold.getDenominator(), this.bitSet);
        }
    }

    @Override
    public void setSuccessThreshold(Ratio threshold) {
        this.bitSet = new CircularBitSet(threshold.getDenominator(), this.bitSet);
    }

    synchronized void checkThreshold() {
        Ratio successRatio = this.breaker.getSuccessThreshold();
        Ratio failureRatio = this.breaker.getFailureThreshold();
        if (successRatio != null) {
            if (this.bitSet.occupiedBits() == successRatio.getDenominator() || successRatio.getValue() == 1.0 && this.bitSet.positiveRatioValue() < 1.0) {
                if (this.bitSet.positiveRatioValue() >= successRatio.getValue()) {
                    this.breaker.close();
                } else {
                    this.breaker.open();
                }
            }
        } else if (failureRatio != null) {
            if (this.bitSet.occupiedBits() == failureRatio.getDenominator() || failureRatio.getValue() == 1.0 && this.bitSet.negativeRatioValue() < 1.0) {
                if (this.bitSet.negativeRatioValue() >= failureRatio.getValue()) {
                    this.breaker.open();
                } else {
                    this.breaker.close();
                }
            }
        } else if (this.bitSet.positiveRatioValue() == 1.0) {
            this.breaker.close();
        } else {
            this.breaker.open();
        }
    }

    int maxConcurrentExecutions() {
        if (this.breaker.getSuccessThreshold() != null) {
            return this.breaker.getSuccessThreshold().getDenominator();
        }
        if (this.breaker.getFailureThreshold() != null) {
            return this.breaker.getFailureThreshold().getDenominator();
        }
        return 1;
    }
}

