/*
 * Decompiled with CFR 0.152.
 */
package org.lable.oss.dynamicconfig;

import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import org.apache.commons.configuration.Configuration;

public class Precomputed<T> {
    final Configuration configuration;
    final Precomputer<T> precomputer;
    final boolean updateOnAnyChange;
    final Map<String, ConfigSubTree> monitoredKeys;
    T precomputedValue;
    long timeOfLastUpdate;

    Precomputed(Configuration configuration, Precomputer<T> precomputer, boolean updateOnAnyChange, String ... monitoredKeys) {
        this.configuration = configuration;
        this.precomputer = precomputer;
        this.updateOnAnyChange = updateOnAnyChange;
        this.monitoredKeys = new HashMap<String, ConfigSubTree>();
        for (String monitoredKey : monitoredKeys) {
            if (monitoredKey == null) {
                throw new IllegalArgumentException("Monitored keys cannot be null.");
            }
            this.monitoredKeys.put(monitoredKey, ConfigSubTree.forPrefix(configuration, monitoredKey));
        }
        this.updateValue();
    }

    public static <T> Precomputed<T> monitorByKeys(Configuration configuration, Precomputer<T> precomputer, String ... monitoredKeys) {
        if (monitoredKeys == null || monitoredKeys.length == 0) {
            throw new IllegalArgumentException("Monitored keys are required.");
        }
        return new Precomputed<T>(configuration, precomputer, false, monitoredKeys);
    }

    public static <T> Precomputed<T> monitorByUpdate(Configuration configuration, Precomputer<T> precomputer) {
        return new Precomputed<T>(configuration, precomputer, true, new String[0]);
    }

    public T get() {
        Optional<Map<String, ConfigSubTree>> optionalConfigState = this.newConfigurationStateIfUpdateNeeded();
        if (optionalConfigState.isPresent()) {
            this.monitoredKeys.replaceAll((key, configSubTree) -> (ConfigSubTree)((Map)optionalConfigState.get()).get(key));
            this.updateValue();
        }
        return this.precomputedValue;
    }

    void updateValue() {
        this.precomputedValue = this.precomputer.compute(this.configuration);
        this.timeOfLastUpdate = System.nanoTime();
    }

    Optional<Map<String, ConfigSubTree>> newConfigurationStateIfUpdateNeeded() {
        if (!this.wasConfigUpdatedSinceLastCheck()) {
            return Optional.empty();
        }
        HashMap<String, ConfigSubTree> newConfigurationState = new HashMap<String, ConfigSubTree>();
        for (String string : this.monitoredKeys.keySet()) {
            newConfigurationState.put(string, ConfigSubTree.forPrefix(this.configuration, string));
        }
        if (this.updateOnAnyChange) {
            return Optional.of(newConfigurationState);
        }
        for (Map.Entry entry : this.monitoredKeys.entrySet()) {
            ConfigSubTree oldConfigSubTree = (ConfigSubTree)entry.getValue();
            if (oldConfigSubTree.equals(newConfigurationState.get(entry.getKey()))) continue;
            return Optional.of(newConfigurationState);
        }
        return Optional.empty();
    }

    boolean wasConfigUpdatedSinceLastCheck() {
        long modifiedAt = this.configuration.getLong("dc.last-modified-at", System.nanoTime());
        return modifiedAt >= this.timeOfLastUpdate;
    }

    static class ConfigSubTree {
        private final String path;
        Map<String, Object> tree;

        private ConfigSubTree(String path, Map<String, Object> tree) {
            this.path = path;
            this.tree = tree;
        }

        public static ConfigSubTree forPrefix(Configuration configuration, String path) {
            HashMap<String, Object> tree = new HashMap<String, Object>();
            configuration.getKeys(path).forEachRemaining(key -> tree.put((String)key, configuration.getProperty((String)key)));
            return new ConfigSubTree(path, tree);
        }

        public int hashCode() {
            return Objects.hash(this.path, this.tree);
        }

        public boolean equals(Object other) {
            if (other == null || !(other instanceof ConfigSubTree)) {
                return false;
            }
            ConfigSubTree that = (ConfigSubTree)other;
            if (!Objects.equals(this.path, that.path)) {
                return false;
            }
            if (this.tree.size() != that.tree.size()) {
                return false;
            }
            Iterator<String> thisTreeKeys = this.tree.keySet().iterator();
            Iterator<String> thatTreeKeys = that.tree.keySet().iterator();
            for (int i = 0; i < this.tree.size(); ++i) {
                if (thisTreeKeys.next().equals(thatTreeKeys.next())) continue;
                return false;
            }
            Iterator<Map.Entry<String, Object>> thisTreeValues = this.tree.entrySet().iterator();
            Iterator<Map.Entry<String, Object>> thatTreeValues = that.tree.entrySet().iterator();
            for (int i = 0; i < this.tree.size(); ++i) {
                if (Objects.equals(thisTreeValues.next().getValue(), thatTreeValues.next().getValue())) continue;
                return false;
            }
            return true;
        }
    }

    @FunctionalInterface
    public static interface Precomputer<T> {
        public T compute(Configuration var1);
    }
}

