/*
 * Decompiled with CFR 0.152.
 */
package io.etcd.jetcd.resolver;

import io.shaded.grpc.NameResolver;
import io.shaded.grpc.NameResolverProvider;
import java.net.URI;
import java.util.Objects;
import javax.annotation.Nullable;

public abstract class AbstractResolverProvider
extends NameResolverProvider {
    private final String scheme;
    private final int priority;

    public AbstractResolverProvider(String scheme, int priority) {
        this.scheme = scheme;
        this.priority = priority;
    }

    @Override
    protected boolean isAvailable() {
        return true;
    }

    @Override
    protected int priority() {
        return this.priority;
    }

    @Override
    public String getDefaultScheme() {
        return this.scheme;
    }

    @Override
    @Nullable
    public NameResolver newNameResolver(URI targetUri, NameResolver.Args args) {
        return Objects.equals(this.scheme, targetUri.getScheme()) ? this.createResolver(targetUri, args) : null;
    }

    protected abstract NameResolver createResolver(URI var1, NameResolver.Args var2);
}

