/*
 * Decompiled with CFR 0.152.
 */
package org.lable.oss.dynamicconfig.core.commonsconfiguration;

import java.io.Closeable;
import java.io.IOException;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.util.Iterator;
import java.util.List;
import java.util.Properties;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReadWriteLock;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import java.util.function.Consumer;
import javax.annotation.PreDestroy;
import org.apache.commons.configuration.CombinedConfiguration;
import org.apache.commons.configuration.Configuration;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ConcurrentConfiguration
implements Configuration,
Closeable {
    private final Logger logger = LoggerFactory.getLogger(ConcurrentConfiguration.class);
    public static final String MODIFICATION_TIMESTAMP = "dc.last-modified-at";
    private final ReadWriteLock lock = new ReentrantReadWriteLock();
    private final Lock readLock = this.lock.readLock();
    private final Lock writeLock = this.lock.writeLock();
    final CombinedConfiguration wrapped;
    final Closeable configurationSource;
    static final String NO_MODIFICATION_MESSAGE = "This configuration class does not permit modification, except through #updateConfiguration(String, Configuration).";

    public ConcurrentConfiguration(CombinedConfiguration wrapped, Closeable configurationSource) {
        this.wrapped = wrapped;
        this.configurationSource = configurationSource;
        this.logger.info("Dynamic Configuration instance created.");
    }

    public ConcurrentConfiguration(CombinedConfiguration wrapped) {
        this(wrapped, null);
    }

    public void withConfiguration(Consumer<CombinedConfiguration> consumer) {
        this.writeLock.lock();
        try {
            consumer.accept(this.wrapped);
            this.markAsModified();
        }
        finally {
            this.writeLock.unlock();
        }
    }

    void markAsModified() {
        this.wrapped.setProperty(MODIFICATION_TIMESTAMP, System.nanoTime());
    }

    @Override
    @PreDestroy
    public void close() throws IOException {
        this.logger.info("Closing Dynamic Configuration instance.");
        if (this.configurationSource != null) {
            this.configurationSource.close();
        }
    }

    @Override
    public void addProperty(String key, Object value) {
        throw new UnsupportedOperationException(NO_MODIFICATION_MESSAGE);
    }

    @Override
    public void setProperty(String key, Object value) {
        throw new UnsupportedOperationException(NO_MODIFICATION_MESSAGE);
    }

    @Override
    public void clearProperty(String key) {
        throw new UnsupportedOperationException(NO_MODIFICATION_MESSAGE);
    }

    @Override
    public void clear() {
        throw new UnsupportedOperationException(NO_MODIFICATION_MESSAGE);
    }

    @Override
    public Configuration subset(String prefix) {
        this.readLock.lock();
        try {
            Configuration configuration = this.wrapped.subset(prefix);
            return configuration;
        }
        finally {
            this.readLock.unlock();
        }
    }

    @Override
    public boolean isEmpty() {
        this.readLock.lock();
        try {
            boolean bl = this.wrapped.isEmpty();
            return bl;
        }
        finally {
            this.readLock.unlock();
        }
    }

    @Override
    public boolean containsKey(String key) {
        this.readLock.lock();
        try {
            boolean bl = this.wrapped.containsKey(key);
            return bl;
        }
        finally {
            this.readLock.unlock();
        }
    }

    @Override
    public Object getProperty(String key) {
        this.readLock.lock();
        try {
            Object object = this.wrapped.getProperty(key);
            return object;
        }
        finally {
            this.readLock.unlock();
        }
    }

    @Override
    public Iterator<String> getKeys(String prefix) {
        this.readLock.lock();
        try {
            Iterator<String> iterator = this.wrapped.getKeys(prefix);
            return iterator;
        }
        finally {
            this.readLock.unlock();
        }
    }

    @Override
    public Iterator<String> getKeys() {
        this.readLock.lock();
        try {
            Iterator<String> iterator = this.wrapped.getKeys();
            return iterator;
        }
        finally {
            this.readLock.unlock();
        }
    }

    @Override
    public Properties getProperties(String key) {
        this.readLock.lock();
        try {
            Properties properties = this.wrapped.getProperties(key);
            return properties;
        }
        finally {
            this.readLock.unlock();
        }
    }

    @Override
    public boolean getBoolean(String key) {
        this.readLock.lock();
        try {
            boolean bl = this.wrapped.getBoolean(key);
            return bl;
        }
        finally {
            this.readLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean getBoolean(String key, boolean defaultValue) {
        this.readLock.lock();
        try {
            boolean bl = this.wrapped.getBoolean(key, defaultValue);
            return bl;
        }
        finally {
            this.readLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Boolean getBoolean(String key, Boolean defaultValue) {
        this.readLock.lock();
        try {
            Boolean bl = this.wrapped.getBoolean(key, defaultValue);
            return bl;
        }
        finally {
            this.readLock.unlock();
        }
    }

    @Override
    public byte getByte(String key) {
        this.readLock.lock();
        try {
            byte by = this.wrapped.getByte(key);
            return by;
        }
        finally {
            this.readLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public byte getByte(String key, byte defaultValue) {
        this.readLock.lock();
        try {
            byte by = this.wrapped.getByte(key, defaultValue);
            return by;
        }
        finally {
            this.readLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Byte getByte(String key, Byte defaultValue) {
        this.readLock.lock();
        try {
            Byte by = this.wrapped.getByte(key, defaultValue);
            return by;
        }
        finally {
            this.readLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public double getDouble(String key) {
        this.readLock.lock();
        try {
            double d = this.wrapped.getDouble(key);
            return d;
        }
        finally {
            this.readLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public double getDouble(String key, double defaultValue) {
        this.readLock.lock();
        try {
            double d = this.wrapped.getDouble(key, defaultValue);
            return d;
        }
        finally {
            this.readLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Double getDouble(String key, Double defaultValue) {
        this.readLock.lock();
        try {
            Double d = this.wrapped.getDouble(key, defaultValue);
            return d;
        }
        finally {
            this.readLock.unlock();
        }
    }

    @Override
    public float getFloat(String key) {
        this.readLock.lock();
        try {
            float f = this.wrapped.getFloat(key);
            return f;
        }
        finally {
            this.readLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public float getFloat(String key, float defaultValue) {
        this.readLock.lock();
        try {
            float f = this.wrapped.getFloat(key, defaultValue);
            return f;
        }
        finally {
            this.readLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Float getFloat(String key, Float defaultValue) {
        this.readLock.lock();
        try {
            Float f = this.wrapped.getFloat(key, defaultValue);
            return f;
        }
        finally {
            this.readLock.unlock();
        }
    }

    @Override
    public int getInt(String key) {
        this.readLock.lock();
        try {
            int n = this.wrapped.getInt(key);
            return n;
        }
        finally {
            this.readLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int getInt(String key, int defaultValue) {
        this.readLock.lock();
        try {
            int n = this.wrapped.getInt(key, defaultValue);
            return n;
        }
        finally {
            this.readLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Integer getInteger(String key, Integer defaultValue) {
        this.readLock.lock();
        try {
            Integer n = this.wrapped.getInteger(key, defaultValue);
            return n;
        }
        finally {
            this.readLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public long getLong(String key) {
        this.readLock.lock();
        try {
            long l = this.wrapped.getLong(key);
            return l;
        }
        finally {
            this.readLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public long getLong(String key, long defaultValue) {
        this.readLock.lock();
        try {
            long l = this.wrapped.getLong(key, defaultValue);
            return l;
        }
        finally {
            this.readLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Long getLong(String key, Long defaultValue) {
        this.readLock.lock();
        try {
            Long l = this.wrapped.getLong(key, defaultValue);
            return l;
        }
        finally {
            this.readLock.unlock();
        }
    }

    @Override
    public short getShort(String key) {
        this.readLock.lock();
        try {
            short s2 = this.wrapped.getShort(key);
            return s2;
        }
        finally {
            this.readLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public short getShort(String key, short defaultValue) {
        this.readLock.lock();
        try {
            short s2 = this.wrapped.getShort(key, defaultValue);
            return s2;
        }
        finally {
            this.readLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Short getShort(String key, Short defaultValue) {
        this.readLock.lock();
        try {
            Short s2 = this.wrapped.getShort(key, defaultValue);
            return s2;
        }
        finally {
            this.readLock.unlock();
        }
    }

    @Override
    public BigDecimal getBigDecimal(String key) {
        this.readLock.lock();
        try {
            BigDecimal bigDecimal = this.wrapped.getBigDecimal(key);
            return bigDecimal;
        }
        finally {
            this.readLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public BigDecimal getBigDecimal(String key, BigDecimal defaultValue) {
        this.readLock.lock();
        try {
            BigDecimal bigDecimal = this.wrapped.getBigDecimal(key, defaultValue);
            return bigDecimal;
        }
        finally {
            this.readLock.unlock();
        }
    }

    @Override
    public BigInteger getBigInteger(String key) {
        this.readLock.lock();
        try {
            BigInteger bigInteger = this.wrapped.getBigInteger(key);
            return bigInteger;
        }
        finally {
            this.readLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public BigInteger getBigInteger(String key, BigInteger defaultValue) {
        this.readLock.lock();
        try {
            BigInteger bigInteger = this.wrapped.getBigInteger(key, defaultValue);
            return bigInteger;
        }
        finally {
            this.readLock.unlock();
        }
    }

    @Override
    public String getString(String key) {
        this.readLock.lock();
        try {
            String string = this.wrapped.getString(key);
            return string;
        }
        finally {
            this.readLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public String getString(String key, String defaultValue) {
        this.readLock.lock();
        try {
            String string = this.wrapped.getString(key, defaultValue);
            return string;
        }
        finally {
            this.readLock.unlock();
        }
    }

    @Override
    public String[] getStringArray(String key) {
        this.readLock.lock();
        try {
            String[] stringArray = this.wrapped.getStringArray(key);
            return stringArray;
        }
        finally {
            this.readLock.unlock();
        }
    }

    @Override
    public List<Object> getList(String key) {
        this.readLock.lock();
        try {
            List<Object> list = this.wrapped.getList(key);
            return list;
        }
        finally {
            this.readLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public List<Object> getList(String key, List<?> defaultValue) {
        this.readLock.lock();
        try {
            List<Object> list = this.wrapped.getList(key, defaultValue);
            return list;
        }
        finally {
            this.readLock.unlock();
        }
    }
}

