/*
 * Decompiled with CFR 0.152.
 */
package org.lable.oss.dynamicconfig.provider;

import java.io.IOException;
import java.io.InputStream;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import org.apache.commons.configuration.Configuration;
import org.lable.oss.dynamicconfig.core.ConfigChangeListener;
import org.lable.oss.dynamicconfig.core.ConfigurationException;
import org.lable.oss.dynamicconfig.core.spi.ConfigurationSource;
import org.lable.oss.dynamicconfig.provider.file.FileWatcher;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FileBasedConfigSource
implements ConfigurationSource {
    private static final Logger logger = LoggerFactory.getLogger(FileBasedConfigSource.class);
    ExecutorService executorService;
    Path rootDir;
    FileWatcher fileWatcher;
    ConfigChangeListener changeListener;
    Map<Path, String> pathNameMapping = new HashMap<Path, String>();

    @Override
    public String name() {
        return "file";
    }

    @Override
    public void configure(Configuration configuration, Configuration defaults, ConfigChangeListener changeListener) throws ConfigurationException {
        String rootConfigFile = configuration.getString("rootconfig");
        if (rootConfigFile == null) {
            throw new ConfigurationException("Parameter rootconfig not set.");
        }
        this.rootDir = Paths.get(rootConfigFile, new String[0]).getParent();
        if (this.rootDir == null || !Files.isDirectory(this.rootDir, new LinkOption[0])) {
            throw new ConfigurationException("Parameter configDir is not a directory (" + rootConfigFile + ").");
        }
        if (changeListener != null) {
            try {
                this.fileWatcher = new FileWatcher(this::handleFileChanged, this.rootDir);
            }
            catch (IOException e) {
                throw new ConfigurationException(e);
            }
            this.changeListener = changeListener;
            this.executorService = Executors.newSingleThreadExecutor();
            this.executorService.execute(this.fileWatcher);
        }
    }

    @Override
    public InputStream load(String name) throws ConfigurationException {
        if (name == null || name.isEmpty()) {
            throw new ConfigurationException("name", "Configuration part name cannot be null or empty.");
        }
        Path filePath = this.rootDir.resolve(name);
        this.pathNameMapping.put(filePath, name);
        try {
            return Files.newInputStream(filePath, new OpenOption[0]);
        }
        catch (IOException e) {
            throw new ConfigurationException("Failed to find configuration part in file " + filePath + ".", e);
        }
    }

    @Override
    public void listen(String name) {
        if (this.changeListener != null) {
            this.fileWatcher.listen(Paths.get(name, new String[0]));
        }
    }

    @Override
    public String normalizeRootConfigName(String rootConfigName) {
        Path path = Paths.get(rootConfigName, new String[0]);
        return path.getFileName().toString();
    }

    @Override
    public void stopListening(String name) {
        if (this.changeListener != null) {
            this.fileWatcher.stopListening(Paths.get(name, new String[0]));
        }
    }

    void handleFileChanged(FileWatcher.Event event, Path filePath) {
        switch (event) {
            case FILE_CREATED: 
            case FILE_MODIFIED: {
                String mutation = event == FileWatcher.Event.FILE_CREATED ? "(re)created" : "modified";
                logger.info("Configuration part file {}, reloading configuration.", (Object)mutation);
                Path relativeToRootDir = this.rootDir.resolve(filePath);
                String name = this.pathNameMapping.putIfAbsent(relativeToRootDir, relativeToRootDir.toString());
                try {
                    this.changeListener.changed(name, this.load(name));
                }
                catch (ConfigurationException e) {
                    logger.error("Failed to load configuration part " + name + ".", e);
                }
                break;
            }
            case FILE_DELETED: {
                logger.warn("Configuration part file {} was deleted. Its contents will be kept in configuration memory until a new file replaces it, or if no other configuration reference it.", (Object)filePath);
                break;
            }
        }
    }

    @Override
    public void close() throws IOException {
        if (this.fileWatcher != null) {
            this.fileWatcher.close();
        }
        if (this.executorService != null) {
            this.executorService.shutdown();
        }
    }
}

