/*
 * Decompiled with CFR 0.152.
 */
package org.lable.oss.dynamicconfig.provider.etcd;

import io.etcd.jetcd.ByteSequence;
import io.etcd.jetcd.Client;
import io.etcd.jetcd.KeyValue;
import io.etcd.jetcd.Watch;
import io.etcd.jetcd.kv.GetResponse;
import io.etcd.jetcd.watch.WatchEvent;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.nio.charset.StandardCharsets;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ExecutionException;
import org.apache.commons.configuration.Configuration;
import org.lable.oss.dynamicconfig.core.ConfigChangeListener;
import org.lable.oss.dynamicconfig.core.ConfigurationException;
import org.lable.oss.dynamicconfig.core.spi.ConfigurationSource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class EtcdAsConfigSource
implements ConfigurationSource {
    private static final Logger logger = LoggerFactory.getLogger(EtcdAsConfigSource.class);
    private Client etcd;
    private String namespace;
    private Map<String, Watch.Watcher> watches = new HashMap<String, Watch.Watcher>();
    private ConfigChangeListener changeListener;

    @Override
    public String name() {
        return "etcd";
    }

    @Override
    public List<String> systemProperties() {
        return Arrays.asList("cluster", "namespace", "copy.cluster.to");
    }

    @Override
    public void configure(Configuration configuration, Configuration defaults, ConfigChangeListener changeListener) throws ConfigurationException {
        String namespace = configuration.getString("namespace");
        String[] cluster = configuration.getStringArray("cluster");
        String copyClusterTo = configuration.getString("copy.cluster.to");
        String rootConfig = configuration.getString("rootconfig");
        if (cluster.length == 0) {
            throw new ConfigurationException("cluster", "No Etcd cluster endpoints specified.");
        }
        if (namespace == null || namespace.isEmpty()) {
            throw new ConfigurationException("namespace", "No namespace specified.");
        }
        if (rootConfig == null || rootConfig.isEmpty()) {
            throw new ConfigurationException("appname", "No application name found.");
        }
        if (copyClusterTo != null) {
            defaults.setProperty(copyClusterTo, cluster);
        }
        this.namespace = namespace;
        this.changeListener = changeListener;
        this.etcd = Client.builder().endpoints(cluster).namespace(ByteSequence.from(namespace, StandardCharsets.UTF_8)).build();
    }

    @Override
    public void listen(String name) {
        if (this.watches.containsKey(name)) {
            return;
        }
        logger.info("Setting watcher on key {}.", (Object)name);
        Watch.Watcher watcher = this.etcd.getWatchClient().watch(EtcdAsConfigSource.nameToByteSequence(name), watchResponse -> {
            List<WatchEvent> events = watchResponse.getEvents();
            for (WatchEvent event : events) {
                KeyValue kv = event.getKeyValue();
                if (!kv.getKey().toString(StandardCharsets.UTF_8).equals(name)) continue;
                switch (event.getEventType()) {
                    case PUT: {
                        byte[] value = kv.getValue().getBytes();
                        this.changeListener.changed(name, new ByteArrayInputStream(value));
                        break;
                    }
                    case DELETE: {
                        logger.error("Configuration key {} deleted. Waiting for it to be recreated\u2026", (Object)name);
                        break;
                    }
                }
            }
        });
        this.watches.put(name, watcher);
    }

    @Override
    public void stopListening(String name) {
        logger.info("Removing watcher from key {}.", (Object)name);
        this.watches.remove(name).close();
    }

    @Override
    public InputStream load(String name) throws ConfigurationException {
        GetResponse getResponse;
        try {
            getResponse = this.etcd.getKVClient().get(EtcdAsConfigSource.nameToByteSequence(name)).get();
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            throw new ConfigurationException(e);
        }
        catch (ExecutionException e) {
            throw new ConfigurationException("Failed to load key " + this.namespace + name + ".", e);
        }
        if (getResponse.getCount() == 0L) {
            throw new ConfigurationException("No such key in etcd: " + this.namespace + name + ".");
        }
        return new ByteArrayInputStream(getResponse.getKvs().get(0).getValue().getBytes());
    }

    @Override
    public void close() throws IOException {
        this.etcd.close();
    }

    static ByteSequence nameToByteSequence(String name) {
        return ByteSequence.from(name, StandardCharsets.UTF_8);
    }
}

