/*
 * Decompiled with CFR 0.152.
 */
package org.lable.oss.dynamicconfig.provider.file;

import java.io.IOException;
import java.nio.file.ClosedWatchServiceException;
import java.nio.file.Path;
import java.nio.file.StandardWatchEventKinds;
import java.nio.file.WatchEvent;
import java.nio.file.WatchKey;
import java.nio.file.WatchService;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FileWatcher
implements Runnable {
    private static final Logger logger = LoggerFactory.getLogger(FileWatcher.class);
    final WatchService watchService;
    final Callback callback;
    final Path dirPath;
    final Set<Path> monitoredFiles;
    final Map<WatchKey, DirectoryContext> watchedDirectories;
    State state = State.RUNNING;

    public FileWatcher(Callback callback, Path dirPath) throws IOException {
        this.callback = callback;
        this.dirPath = dirPath;
        this.monitoredFiles = new HashSet<Path>();
        this.watchedDirectories = new HashMap<WatchKey, DirectoryContext>();
        this.watchService = dirPath.getFileSystem().newWatchService();
    }

    public synchronized void listen(Path filePath) {
        Path parentDir = this.dirPath.resolve(filePath).getParent();
        boolean alreadyWatched = false;
        for (DirectoryContext directoryContext : this.watchedDirectories.values()) {
            if (!directoryContext.getPath().equals(parentDir)) continue;
            directoryContext.increment();
            alreadyWatched = true;
            break;
        }
        if (!alreadyWatched) {
            WatchKey watchKey;
            try {
                watchKey = parentDir.register(this.watchService, StandardWatchEventKinds.ENTRY_MODIFY, StandardWatchEventKinds.ENTRY_CREATE, StandardWatchEventKinds.ENTRY_DELETE);
            }
            catch (IOException e) {
                logger.error("Failed to register watcher at path " + parentDir, e);
                return;
            }
            this.watchedDirectories.put(watchKey, new DirectoryContext(parentDir));
            logger.info("Started listening to directory {} for changes.", (Object)parentDir);
        }
        this.monitoredFiles.add(filePath);
    }

    public synchronized void stopListening(Path filePath) {
        if (this.monitoredFiles.remove(filePath)) {
            Path fileParent = filePath.getParent();
            Path parentDir = fileParent == null ? this.dirPath : this.dirPath.resolve(fileParent);
            this.watchedDirectories.entrySet().removeIf(entry -> {
                DirectoryContext directoryContext = (DirectoryContext)entry.getValue();
                if (directoryContext.getPath().equals(parentDir)) {
                    directoryContext.decrement();
                }
                return directoryContext.noFilesWatched();
            });
        }
    }

    @Override
    public void run() {
        logger.info("Starting file watcher for {}.", (Object)this.dirPath);
        try {
            WatchKey key = this.watchService.take();
            while (this.state == State.RUNNING && key != null) {
                Thread.sleep(50L);
                for (WatchEvent<?> event : key.pollEvents()) {
                    Event eventType;
                    if (event.kind().type() != Path.class) continue;
                    WatchEvent<?> pathEvent = event;
                    Path eventPath = (Path)pathEvent.context();
                    Path eventDir = this.watchedDirectories.get(key).getPath();
                    Path relativePath = this.dirPath.relativize(eventDir).resolve(eventPath);
                    if (eventPath.toFile().isDirectory()) {
                        System.out.println("!!!!!!");
                        continue;
                    }
                    if (!this.monitoredFiles.contains(relativePath) || (eventType = Event.eventFromWatchEventKind(pathEvent.kind())) == null) continue;
                    this.callback.fileChanged(eventType, relativePath);
                }
                key.reset();
                key = this.watchService.take();
            }
        }
        catch (ClosedWatchServiceException e) {
            logger.info("Stopping file watcher for {}.", (Object)this.dirPath);
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
        }
    }

    public void close() throws IOException {
        this.state = State.SHUTTING_DOWN;
        this.watchService.close();
    }

    static class DirectoryContext {
        int watchedFiles = 1;
        Path dirPath;

        DirectoryContext(Path dirPath) {
            this.dirPath = dirPath;
        }

        Path getPath() {
            return this.dirPath;
        }

        void increment() {
            ++this.watchedFiles;
        }

        void decrement() {
            --this.watchedFiles;
        }

        boolean noFilesWatched() {
            return this.watchedFiles == 0;
        }
    }

    static enum State {
        RUNNING,
        SHUTTING_DOWN;

    }

    public static enum Event {
        FILE_MODIFIED,
        FILE_CREATED,
        FILE_DELETED;


        public static Event eventFromWatchEventKind(WatchEvent.Kind kind) {
            if (kind == null) {
                return null;
            }
            switch (kind.name()) {
                case "ENTRY_CREATE": {
                    return FILE_CREATED;
                }
                case "ENTRY_DELETE": {
                    return FILE_DELETED;
                }
                case "ENTRY_MODIFY": {
                    return FILE_MODIFIED;
                }
            }
            return null;
        }
    }

    public static interface Callback {
        public void fileChanged(Event var1, Path var2);
    }
}

