/*
 * Decompiled with CFR 0.152.
 */
package io.shaded.netty.handler.codec.dns;

import io.shaded.netty.buffer.ByteBuf;
import io.shaded.netty.channel.ChannelHandler;
import io.shaded.netty.channel.ChannelHandlerContext;
import io.shaded.netty.handler.codec.MessageToMessageEncoder;
import io.shaded.netty.handler.codec.dns.DnsMessageUtil;
import io.shaded.netty.handler.codec.dns.DnsRecordEncoder;
import io.shaded.netty.handler.codec.dns.DnsResponse;
import io.shaded.netty.util.internal.ObjectUtil;
import java.util.List;

@ChannelHandler.Sharable
public final class TcpDnsResponseEncoder
extends MessageToMessageEncoder<DnsResponse> {
    private final DnsRecordEncoder encoder;

    public TcpDnsResponseEncoder() {
        this(DnsRecordEncoder.DEFAULT);
    }

    public TcpDnsResponseEncoder(DnsRecordEncoder encoder) {
        this.encoder = ObjectUtil.checkNotNull(encoder, "encoder");
    }

    @Override
    protected void encode(ChannelHandlerContext ctx, DnsResponse response, List<Object> out) throws Exception {
        ByteBuf buf = ctx.alloc().ioBuffer(1024);
        buf.writerIndex(buf.writerIndex() + 2);
        DnsMessageUtil.encodeDnsResponse(this.encoder, response, buf);
        buf.setShort(0, buf.readableBytes() - 2);
        out.add(buf);
    }
}

