/*
 * Decompiled with CFR 0.152.
 */
package io.shaded.netty.resolver.dns;

import io.shaded.netty.handler.codec.dns.DnsQuestion;
import io.shaded.netty.handler.logging.LogLevel;
import io.shaded.netty.resolver.dns.DnsQueryLifecycleObserver;
import io.shaded.netty.resolver.dns.DnsQueryLifecycleObserverFactory;
import io.shaded.netty.resolver.dns.LoggingDnsQueryLifecycleObserver;
import io.shaded.netty.util.internal.ObjectUtil;
import io.shaded.netty.util.internal.logging.InternalLogLevel;
import io.shaded.netty.util.internal.logging.InternalLogger;
import io.shaded.netty.util.internal.logging.InternalLoggerFactory;

public final class LoggingDnsQueryLifeCycleObserverFactory
implements DnsQueryLifecycleObserverFactory {
    private static final InternalLogger DEFAULT_LOGGER = InternalLoggerFactory.getInstance(LoggingDnsQueryLifeCycleObserverFactory.class);
    private final InternalLogger logger;
    private final InternalLogLevel level;

    public LoggingDnsQueryLifeCycleObserverFactory() {
        this(LogLevel.DEBUG);
    }

    public LoggingDnsQueryLifeCycleObserverFactory(LogLevel level) {
        this.level = LoggingDnsQueryLifeCycleObserverFactory.checkAndConvertLevel(level);
        this.logger = DEFAULT_LOGGER;
    }

    public LoggingDnsQueryLifeCycleObserverFactory(Class<?> classContext, LogLevel level) {
        this.level = LoggingDnsQueryLifeCycleObserverFactory.checkAndConvertLevel(level);
        this.logger = InternalLoggerFactory.getInstance(ObjectUtil.checkNotNull(classContext, "classContext"));
    }

    public LoggingDnsQueryLifeCycleObserverFactory(String name, LogLevel level) {
        this.level = LoggingDnsQueryLifeCycleObserverFactory.checkAndConvertLevel(level);
        this.logger = InternalLoggerFactory.getInstance(ObjectUtil.checkNotNull(name, "name"));
    }

    private static InternalLogLevel checkAndConvertLevel(LogLevel level) {
        return ObjectUtil.checkNotNull(level, "level").toInternalLevel();
    }

    @Override
    public DnsQueryLifecycleObserver newDnsQueryLifecycleObserver(DnsQuestion question) {
        return new LoggingDnsQueryLifecycleObserver(question, this.logger, this.level);
    }
}

