/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.core.http.impl;

import io.shaded.netty.channel.EventLoop;
import io.shaded.netty.handler.codec.compression.CompressionOptions;
import io.shaded.netty.handler.codec.http.HttpContentCompressor;
import io.shaded.netty.handler.codec.http.HttpHeaderNames;
import io.shaded.netty.handler.codec.http2.DefaultHttp2Headers;
import io.shaded.netty.handler.codec.http2.Http2Error;
import io.shaded.netty.handler.codec.http2.Http2Headers;
import io.shaded.netty.handler.codec.http2.Http2Settings;
import io.shaded.netty.handler.codec.http2.Http2Stream;
import io.shaded.netty.util.concurrent.Future;
import io.vertx.core.AsyncResult;
import io.vertx.core.Handler;
import io.vertx.core.MultiMap;
import io.vertx.core.Promise;
import io.vertx.core.http.HttpMethod;
import io.vertx.core.http.HttpServerOptions;
import io.vertx.core.http.HttpServerRequest;
import io.vertx.core.http.HttpServerResponse;
import io.vertx.core.http.StreamPriority;
import io.vertx.core.http.StreamResetException;
import io.vertx.core.http.impl.Http2ConnectionBase;
import io.vertx.core.http.impl.Http2ServerRequest;
import io.vertx.core.http.impl.Http2ServerResponse;
import io.vertx.core.http.impl.Http2ServerStream;
import io.vertx.core.http.impl.Http2ServerStreamHandler;
import io.vertx.core.http.impl.HttpServerConnection;
import io.vertx.core.http.impl.VertxHttp2ConnectionHandler;
import io.vertx.core.http.impl.VertxHttp2Stream;
import io.vertx.core.impl.ContextInternal;
import io.vertx.core.impl.EventLoopContext;
import io.vertx.core.spi.metrics.HttpServerMetrics;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.ArrayDeque;
import java.util.function.Function;
import java.util.function.Supplier;

public class Http2ServerConnection
extends Http2ConnectionBase
implements HttpServerConnection {
    final HttpServerOptions options;
    private final String serverOrigin;
    private final HttpServerMetrics metrics;
    private final Function<String, String> encodingDetector;
    private final Supplier<ContextInternal> streamContextSupplier;
    Handler<HttpServerRequest> requestHandler;
    private int concurrentStreams;
    private final ArrayDeque<Push> pendingPushes = new ArrayDeque(8);
    private VertxHttp2Stream upgraded;

    Http2ServerConnection(EventLoopContext context, Supplier<ContextInternal> streamContextSupplier, String serverOrigin, VertxHttp2ConnectionHandler connHandler, Function<String, String> encodingDetector, HttpServerOptions options, HttpServerMetrics metrics) {
        super(context, connHandler);
        this.options = options;
        this.serverOrigin = serverOrigin;
        this.encodingDetector = encodingDetector;
        this.streamContextSupplier = streamContextSupplier;
        this.metrics = metrics;
    }

    @Override
    public HttpServerConnection handler(Handler<HttpServerRequest> handler) {
        this.requestHandler = handler;
        return this;
    }

    @Override
    public HttpServerConnection invalidRequestHandler(Handler<HttpServerRequest> handler) {
        return this;
    }

    @Override
    public HttpServerMetrics metrics() {
        return this.metrics;
    }

    private static boolean isMalformedRequest(Http2Headers headers) {
        if (headers.method() == null) {
            return true;
        }
        String method = headers.method().toString();
        if (method.equals("CONNECT") ? headers.scheme() != null || headers.path() != null || headers.authority() == null : headers.method() == null || headers.scheme() == null || headers.path() == null || headers.path().length() == 0) {
            return true;
        }
        if (headers.authority() != null) {
            URI uri;
            try {
                uri = new URI(null, headers.authority().toString(), null, null, null);
            }
            catch (URISyntaxException e) {
                return true;
            }
            if (uri.getRawUserInfo() != null) {
                return true;
            }
        }
        return false;
    }

    String determineContentEncoding(Http2Headers headers) {
        String acceptEncoding;
        String string = acceptEncoding = headers.get(HttpHeaderNames.ACCEPT_ENCODING) != null ? ((CharSequence)headers.get(HttpHeaderNames.ACCEPT_ENCODING)).toString() : null;
        if (acceptEncoding != null && this.encodingDetector != null) {
            return this.encodingDetector.apply(acceptEncoding);
        }
        return null;
    }

    private Http2ServerStream createStream(int streamId, Http2Headers headers, boolean streamEnded) {
        Http2Stream stream = this.handler.connection().stream(streamId);
        String contentEncoding = this.options.isCompressionSupported() ? this.determineContentEncoding(headers) : null;
        Http2ServerStream vertxStream = new Http2ServerStream(this, this.streamContextSupplier.get(), headers, this.serverOrigin, this.options.getTracingPolicy(), streamEnded);
        Http2ServerRequest request = new Http2ServerRequest(vertxStream, this.serverOrigin, headers, contentEncoding);
        vertxStream.request = request;
        vertxStream.isConnect = request.method() == HttpMethod.CONNECT;
        vertxStream.init(stream);
        return vertxStream;
    }

    @Override
    VertxHttp2Stream<?> stream(int id) {
        VertxHttp2Stream<?> stream = super.stream(id);
        if (stream == null && id == 1 && this.handler.upgraded) {
            return this.upgraded;
        }
        return stream;
    }

    @Override
    protected synchronized void onHeadersRead(int streamId, Http2Headers headers, StreamPriority streamPriority, boolean endOfStream) {
        Http2ServerStream stream = this.stream(streamId);
        if (stream == null) {
            if (Http2ServerConnection.isMalformedRequest(headers)) {
                this.handler.writeReset(streamId, Http2Error.PROTOCOL_ERROR.code());
                return;
            }
            if (streamId == 1 && this.handler.upgraded) {
                stream = this.createStream(streamId, headers, true);
                this.upgraded = stream;
            } else {
                stream = this.createStream(streamId, headers, endOfStream);
            }
            ((VertxHttp2Stream)stream).onHeaders(headers, streamPriority);
        }
        if (endOfStream) {
            stream.onEnd();
        }
    }

    void sendPush(int streamId, String host, HttpMethod method, MultiMap headers, String path, StreamPriority streamPriority, Promise<HttpServerResponse> promise) {
        EventLoop eventLoop = this.context.nettyEventLoop();
        if (eventLoop.inEventLoop()) {
            this.doSendPush(streamId, host, method, headers, path, streamPriority, promise);
        } else {
            eventLoop.execute(() -> this.doSendPush(streamId, host, method, headers, path, streamPriority, promise));
        }
    }

    private synchronized void doSendPush(int streamId, String host, HttpMethod method, MultiMap headers, String path, StreamPriority streamPriority, Promise<HttpServerResponse> promise) {
        DefaultHttp2Headers headers_ = new DefaultHttp2Headers();
        headers_.method(method.name());
        headers_.path(path);
        headers_.scheme(this.isSsl() ? "https" : "http");
        if (host != null) {
            headers_.authority(host);
        }
        if (headers != null) {
            headers.forEach(header -> {
                Http2Headers cfr_ignored_0 = (Http2Headers)headers_.add(header.getKey(), header.getValue());
            });
        }
        Future<Integer> fut = this.handler.writePushPromise(streamId, headers_);
        fut.addListener(future -> {
            if (future.isSuccess()) {
                Http2ServerConnection http2ServerConnection = this;
                synchronized (http2ServerConnection) {
                    int promisedStreamId = (Integer)future.getNow();
                    String contentEncoding = this.determineContentEncoding(headers_);
                    Http2Stream promisedStream = this.handler.connection().stream(promisedStreamId);
                    Http2ServerStream vertxStream = new Http2ServerStream(this, this.context, method, path, this.options.getTracingPolicy(), true);
                    Push push = new Push(vertxStream, contentEncoding, promise);
                    vertxStream.request = push;
                    push.stream.priority(streamPriority);
                    push.stream.init(promisedStream);
                    int maxConcurrentStreams = this.handler.maxConcurrentStreams();
                    if (this.concurrentStreams < maxConcurrentStreams) {
                        ++this.concurrentStreams;
                        push.complete();
                    } else {
                        this.pendingPushes.add(push);
                    }
                }
            } else {
                promise.fail(future.cause());
            }
        });
    }

    @Override
    protected void updateSettings(Http2Settings settingsUpdate, Handler<AsyncResult<Void>> completionHandler) {
        settingsUpdate.remove('\u0002');
        super.updateSettings(settingsUpdate, completionHandler);
    }

    private class Push
    implements Http2ServerStreamHandler {
        protected final ContextInternal context;
        protected final Http2ServerStream stream;
        protected final Http2ServerResponse response;
        private final Promise<HttpServerResponse> promise;

        public Push(Http2ServerStream stream, String contentEncoding, Promise<HttpServerResponse> promise) {
            this.context = stream.context;
            this.stream = stream;
            this.response = new Http2ServerResponse((Http2ServerConnection)stream.conn, stream, true, contentEncoding);
            this.promise = promise;
        }

        @Override
        public Http2ServerResponse response() {
            return this.response;
        }

        @Override
        public void dispatch(Handler<HttpServerRequest> handler) {
            throw new UnsupportedOperationException();
        }

        @Override
        public void handleReset(long errorCode) {
            if (!this.promise.tryFail(new StreamResetException(errorCode))) {
                this.response.handleReset(errorCode);
            }
        }

        @Override
        public void handleException(Throwable cause) {
            if (this.response != null) {
                this.response.handleException(cause);
            }
        }

        @Override
        public void handleClose() {
            if (Http2ServerConnection.this.pendingPushes.remove(this)) {
                this.promise.fail("Push reset by client");
            } else {
                Http2ServerConnection.this.concurrentStreams--;
                int maxConcurrentStreams = Http2ServerConnection.this.handler.maxConcurrentStreams();
                while (Http2ServerConnection.this.concurrentStreams < maxConcurrentStreams && Http2ServerConnection.this.pendingPushes.size() > 0) {
                    Push push = (Push)Http2ServerConnection.this.pendingPushes.pop();
                    Http2ServerConnection.this.concurrentStreams++;
                    push.complete();
                }
                this.response.handleClose();
            }
        }

        void complete() {
            this.stream.registerMetrics();
            this.promise.complete(this.response);
        }
    }

    private static class EncodingDetector
    extends HttpContentCompressor {
        private EncodingDetector(CompressionOptions[] compressionOptions) {
            super(compressionOptions);
        }

        @Override
        protected String determineEncoding(String acceptEncoding) {
            return super.determineEncoding(acceptEncoding);
        }
    }
}

