/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.core.http.impl;

import io.shaded.netty.buffer.ByteBuf;
import io.shaded.netty.buffer.Unpooled;
import io.shaded.netty.channel.ChannelHandlerContext;
import io.shaded.netty.channel.DefaultFileRegion;
import io.shaded.netty.handler.codec.http.DefaultFullHttpResponse;
import io.shaded.netty.handler.codec.http.DefaultHttpContent;
import io.shaded.netty.handler.codec.http.HttpHeaders;
import io.shaded.netty.handler.codec.http.HttpResponse;
import io.shaded.netty.handler.codec.http.HttpResponseEncoder;
import io.shaded.netty.handler.codec.http.LastHttpContent;
import io.vertx.core.http.impl.AssembledFullHttpResponse;
import io.vertx.core.http.impl.AssembledHttpResponse;
import io.vertx.core.http.impl.AssembledLastHttpContent;
import io.vertx.core.http.impl.headers.HeadersMultiMap;

final class VertxHttpResponseEncoder
extends HttpResponseEncoder {
    VertxHttpResponseEncoder() {
    }

    @Override
    protected void encodeHeaders(HttpHeaders headers, ByteBuf buf) {
        if (headers instanceof HeadersMultiMap) {
            HeadersMultiMap vertxHeaders = (HeadersMultiMap)headers;
            vertxHeaders.encode(buf);
        } else {
            super.encodeHeaders(headers, buf);
        }
    }

    @Override
    public boolean acceptOutboundMessage(Object msg) throws Exception {
        if (msg == Unpooled.EMPTY_BUFFER || msg == LastHttpContent.EMPTY_LAST_CONTENT) {
            return true;
        }
        Class<?> msgClazz = msg.getClass();
        if (msgClazz == AssembledFullHttpResponse.class || msgClazz == DefaultFullHttpResponse.class || msgClazz == AssembledHttpResponse.class || msgClazz == DefaultHttpContent.class || msgClazz == AssembledLastHttpContent.class || msgClazz == DefaultFileRegion.class) {
            return true;
        }
        return super.acceptOutboundMessage(msg);
    }

    @Override
    public void handlerAdded(ChannelHandlerContext ctx) throws Exception {
        super.handlerAdded(ctx);
    }

    @Override
    protected boolean isContentAlwaysEmpty(HttpResponse msg) {
        return msg instanceof AssembledHttpResponse && ((AssembledHttpResponse)msg).head() || super.isContentAlwaysEmpty(msg);
    }
}

