/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.core.parsetools.impl;

import io.shaded.netty.buffer.Unpooled;
import io.vertx.core.Handler;
import io.vertx.core.buffer.Buffer;
import io.vertx.core.impl.Arguments;
import io.vertx.core.parsetools.RecordParser;
import io.vertx.core.streams.ReadStream;
import java.util.Objects;

public class RecordParserImpl
implements RecordParser {
    private static final Buffer EMPTY_BUFFER = Buffer.buffer(Unpooled.EMPTY_BUFFER);
    private Buffer buff = EMPTY_BUFFER;
    private int pos;
    private int start;
    private int delimPos;
    private boolean delimited;
    private byte[] delim;
    private int recordSize;
    private int maxRecordSize;
    private long demand = Long.MAX_VALUE;
    private Handler<Buffer> eventHandler;
    private Handler<Void> endHandler;
    private Handler<Throwable> exceptionHandler;
    private boolean parsing;
    private boolean streamEnded;
    private final ReadStream<Buffer> stream;

    private RecordParserImpl(ReadStream<Buffer> stream) {
        this.stream = stream;
    }

    @Override
    public void setOutput(Handler<Buffer> output) {
        Objects.requireNonNull(output, "output");
        this.eventHandler = output;
    }

    public static Buffer latin1StringToBytes(String str) {
        byte[] bytes = new byte[str.length()];
        for (int i = 0; i < str.length(); ++i) {
            char c = str.charAt(i);
            bytes[i] = (byte)(c & 0xFF);
        }
        return Buffer.buffer(bytes);
    }

    public static RecordParser newDelimited(String delim, ReadStream<Buffer> stream, Handler<Buffer> output) {
        return RecordParserImpl.newDelimited(RecordParserImpl.latin1StringToBytes(delim), stream, output);
    }

    public static RecordParser newDelimited(Buffer delim, ReadStream<Buffer> stream, Handler<Buffer> output) {
        RecordParserImpl ls = new RecordParserImpl(stream);
        ls.handler((Handler)output);
        ls.delimitedMode(delim);
        return ls;
    }

    public static RecordParser newFixed(int size, ReadStream<Buffer> stream, Handler<Buffer> output) {
        Arguments.require(size > 0, "Size must be > 0");
        RecordParserImpl ls = new RecordParserImpl(stream);
        ls.handler((Handler)output);
        ls.fixedSizeMode(size);
        return ls;
    }

    @Override
    public void delimitedMode(String delim) {
        this.delimitedMode(RecordParserImpl.latin1StringToBytes(delim));
    }

    @Override
    public void delimitedMode(Buffer delim) {
        Objects.requireNonNull(delim, "delim");
        this.delimited = true;
        this.delim = delim.getBytes();
        this.delimPos = 0;
    }

    @Override
    public void fixedSizeMode(int size) {
        Arguments.require(size > 0, "Size must be > 0");
        this.delimited = false;
        this.recordSize = size;
    }

    @Override
    public RecordParser maxRecordSize(int size) {
        Arguments.require(size > 0, "Size must be > 0");
        this.maxRecordSize = size;
        return this;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void handleParsing() {
        if (this.parsing) {
            return;
        }
        this.parsing = true;
        try {
            block17: {
                while (this.demand > 0L) {
                    int next = this.delimited ? this.parseDelimited() : this.parseFixed();
                    if (next == -1) {
                        if (this.streamEnded) {
                            if (this.buff.length() == 0) break block17;
                            next = this.buff.length();
                        } else {
                            ReadStream<Buffer> s2 = this.stream;
                            if (s2 != null) {
                                s2.resume();
                            }
                            if (this.streamEnded) {
                                continue;
                            }
                            break block17;
                        }
                    }
                    if (this.demand != Long.MAX_VALUE) {
                        --this.demand;
                    }
                    Buffer event = this.buff.getBuffer(this.start, next);
                    this.start = this.pos;
                    Handler<Buffer> handler = this.eventHandler;
                    if (handler != null) {
                        handler.handle(event);
                    }
                    if (!this.streamEnded) continue;
                    break block17;
                }
                ReadStream<Buffer> s3 = this.stream;
                if (s3 != null) {
                    s3.pause();
                }
            }
            int len = this.buff.length();
            if (this.start == len) {
                this.buff = EMPTY_BUFFER;
            } else if (this.start > 0) {
                this.buff = this.buff.getBuffer(this.start, len);
            }
            this.pos -= this.start;
            this.start = 0;
            if (this.streamEnded) {
                this.end();
            }
        }
        finally {
            this.parsing = false;
        }
    }

    private int parseDelimited() {
        int len = this.buff.length();
        while (this.pos < len) {
            if (this.buff.getByte(this.pos) == this.delim[this.delimPos]) {
                ++this.delimPos;
                if (this.delimPos == this.delim.length) {
                    ++this.pos;
                    this.delimPos = 0;
                    return this.pos - this.delim.length;
                }
            } else if (this.delimPos > 0) {
                this.pos -= this.delimPos;
                this.delimPos = 0;
            }
            ++this.pos;
        }
        return -1;
    }

    private int parseFixed() {
        int len = this.buff.length();
        if (len - this.start >= this.recordSize) {
            int end;
            this.pos = end = this.start + this.recordSize;
            return end;
        }
        return -1;
    }

    @Override
    public void handle(Buffer buffer) {
        if (this.buff.length() == 0) {
            this.buff = buffer;
        } else {
            this.buff.appendBuffer(buffer);
        }
        this.handleParsing();
        if (this.buff != null && this.maxRecordSize > 0 && this.buff.length() > this.maxRecordSize) {
            IllegalStateException ex = new IllegalStateException("The current record is too long");
            if (this.exceptionHandler != null) {
                this.exceptionHandler.handle(ex);
            } else {
                throw ex;
            }
        }
    }

    private void end() {
        Handler<Void> handler = this.endHandler;
        if (handler != null) {
            handler.handle(null);
        }
    }

    @Override
    public RecordParser exceptionHandler(Handler<Throwable> handler) {
        this.exceptionHandler = handler;
        return this;
    }

    @Override
    public RecordParser handler(Handler<Buffer> handler) {
        this.eventHandler = handler;
        if (this.stream != null) {
            if (handler != null) {
                this.stream.endHandler((Void v) -> {
                    this.streamEnded = true;
                    this.handleParsing();
                });
                this.stream.exceptionHandler(err -> {
                    if (this.exceptionHandler != null) {
                        this.exceptionHandler.handle((Throwable)err);
                    }
                });
                this.stream.handler(this);
            } else {
                this.stream.handler(null);
                this.stream.endHandler(null);
                this.stream.exceptionHandler((Handler)null);
            }
        }
        return this;
    }

    @Override
    public RecordParser pause() {
        this.demand = 0L;
        return this;
    }

    @Override
    public RecordParser fetch(long amount) {
        Arguments.require(amount > 0L, "Fetch amount must be > 0");
        this.demand += amount;
        if (this.demand < 0L) {
            this.demand = Long.MAX_VALUE;
        }
        this.handleParsing();
        return this;
    }

    @Override
    public RecordParser resume() {
        return this.fetch(Long.MAX_VALUE);
    }

    @Override
    public RecordParser endHandler(Handler<Void> handler) {
        this.endHandler = handler;
        return this;
    }
}

