/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.configuration;

import java.io.File;
import java.io.PrintStream;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.Iterator;
import org.apache.commons.configuration.Configuration;
import org.apache.commons.configuration.ConfigurationRuntimeException;
import org.apache.commons.configuration.FileSystem;
import org.apache.commons.configuration.HierarchicalConfiguration;
import org.apache.commons.configuration.event.ConfigurationErrorEvent;
import org.apache.commons.configuration.event.ConfigurationErrorListener;
import org.apache.commons.configuration.event.EventSource;
import org.apache.commons.configuration.reloading.Reloadable;
import org.apache.commons.configuration.tree.ExpressionEngine;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public final class ConfigurationUtils {
    static final String PROTOCOL_FILE = "file";
    static final String RESOURCE_PATH_SEPARATOR = "/";
    private static final String FILE_SCHEME = "file:";
    private static final String METHOD_CLONE = "clone";
    private static final int HEX = 16;
    private static final Log LOG = LogFactory.getLog(ConfigurationUtils.class);

    private ConfigurationUtils() {
    }

    public static void dump(Configuration configuration, PrintStream out) {
        ConfigurationUtils.dump(configuration, new PrintWriter(out));
    }

    public static void dump(Configuration configuration, PrintWriter out) {
        Iterator<String> keys = configuration.getKeys();
        while (keys.hasNext()) {
            String key = keys.next();
            Object value = configuration.getProperty(key);
            out.print(key);
            out.print("=");
            out.print(value);
            if (!keys.hasNext()) continue;
            out.println();
        }
        out.flush();
    }

    public static String toString(Configuration configuration) {
        StringWriter writer = new StringWriter();
        ConfigurationUtils.dump(configuration, new PrintWriter(writer));
        return writer.toString();
    }

    public static void copy(Configuration source, Configuration target) {
        Iterator<String> keys = source.getKeys();
        while (keys.hasNext()) {
            String key = keys.next();
            target.setProperty(key, source.getProperty(key));
        }
    }

    public static void append(Configuration source, Configuration target) {
        Iterator<String> keys = source.getKeys();
        while (keys.hasNext()) {
            String key = keys.next();
            target.addProperty(key, source.getProperty(key));
        }
    }

    public static HierarchicalConfiguration convertToHierarchical(Configuration conf) {
        return ConfigurationUtils.convertToHierarchical(conf, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static HierarchicalConfiguration convertToHierarchical(Configuration conf, ExpressionEngine engine) {
        if (conf == null) {
            return null;
        }
        if (conf instanceof HierarchicalConfiguration) {
            HierarchicalConfiguration hc;
            if (conf instanceof Reloadable) {
                Object lock;
                Object object = lock = ((Reloadable)((Object)conf)).getReloadLock();
                synchronized (object) {
                    hc = new HierarchicalConfiguration((HierarchicalConfiguration)conf);
                }
            } else {
                hc = (HierarchicalConfiguration)conf;
            }
            if (engine != null) {
                hc.setExpressionEngine(engine);
            }
            return hc;
        }
        HierarchicalConfiguration hc = new HierarchicalConfiguration();
        if (engine != null) {
            hc.setExpressionEngine(engine);
        }
        boolean delimiterParsingStatus = hc.isDelimiterParsingDisabled();
        hc.setDelimiterParsingDisabled(true);
        hc.append(conf);
        hc.setDelimiterParsingDisabled(delimiterParsingStatus);
        return hc;
    }

    public static Configuration cloneConfiguration(Configuration config) throws ConfigurationRuntimeException {
        if (config == null) {
            return null;
        }
        try {
            return (Configuration)ConfigurationUtils.clone(config);
        }
        catch (CloneNotSupportedException cnex) {
            throw new ConfigurationRuntimeException(cnex);
        }
    }

    static Object clone(Object obj) throws CloneNotSupportedException {
        if (obj instanceof Cloneable) {
            try {
                Method m4 = obj.getClass().getMethod(METHOD_CLONE, new Class[0]);
                return m4.invoke(obj, new Object[0]);
            }
            catch (NoSuchMethodException nmex) {
                throw new CloneNotSupportedException("No clone() method found for class" + obj.getClass().getName());
            }
            catch (IllegalAccessException iaex) {
                throw new ConfigurationRuntimeException(iaex);
            }
            catch (InvocationTargetException itex) {
                throw new ConfigurationRuntimeException(itex);
            }
        }
        throw new CloneNotSupportedException(obj.getClass().getName() + " does not implement Cloneable");
    }

    public static URL getURL(String basePath, String file) throws MalformedURLException {
        return FileSystem.getDefaultFileSystem().getURL(basePath, file);
    }

    static File constructFile(String basePath, String fileName) {
        File file;
        File absolute = null;
        if (fileName != null) {
            absolute = new File(fileName);
        }
        if (StringUtils.isEmpty(basePath) || absolute != null && absolute.isAbsolute()) {
            file = new File(fileName);
        } else {
            StringBuilder fName = new StringBuilder();
            fName.append(basePath);
            if (!basePath.endsWith(File.separator)) {
                fName.append(File.separator);
            }
            if (fileName.startsWith("." + File.separator)) {
                fName.append(fileName.substring(2));
            } else {
                fName.append(fileName);
            }
            file = new File(fName.toString());
        }
        return file;
    }

    public static URL locate(String name) {
        return ConfigurationUtils.locate(null, name);
    }

    public static URL locate(String base, String name) {
        return ConfigurationUtils.locate(FileSystem.getDefaultFileSystem(), base, name);
    }

    public static URL locate(FileSystem fileSystem, String base, String name) {
        File file;
        if (LOG.isDebugEnabled()) {
            StringBuilder buf = new StringBuilder();
            buf.append("ConfigurationUtils.locate(): base is ").append(base);
            buf.append(", name is ").append(name);
            LOG.debug(buf.toString());
        }
        if (name == null) {
            return null;
        }
        URL url = fileSystem.locateFromURL(base, name);
        if (url == null && (file = new File(name)).isAbsolute() && file.exists()) {
            try {
                url = ConfigurationUtils.toURL(file);
                LOG.debug("Loading configuration from the absolute path " + name);
            }
            catch (MalformedURLException e) {
                LOG.warn("Could not obtain URL from file", e);
            }
        }
        if (url == null) {
            try {
                file = ConfigurationUtils.constructFile(base, name);
                if (file != null && file.exists()) {
                    url = ConfigurationUtils.toURL(file);
                }
                if (url != null) {
                    LOG.debug("Loading configuration from the path " + file);
                }
            }
            catch (MalformedURLException e) {
                LOG.warn("Could not obtain URL from file", e);
            }
        }
        if (url == null) {
            try {
                file = ConfigurationUtils.constructFile(System.getProperty("user.home"), name);
                if (file != null && file.exists()) {
                    url = ConfigurationUtils.toURL(file);
                }
                if (url != null) {
                    LOG.debug("Loading configuration from the home path " + file);
                }
            }
            catch (MalformedURLException e) {
                LOG.warn("Could not obtain URL from file", e);
            }
        }
        if (url == null) {
            url = ConfigurationUtils.locateFromClasspath(name);
        }
        return url;
    }

    static URL locateFromClasspath(String resourceName) {
        URL url = null;
        ClassLoader loader = Thread.currentThread().getContextClassLoader();
        if (loader != null && (url = loader.getResource(resourceName)) != null) {
            LOG.debug("Loading configuration from the context classpath (" + resourceName + ")");
        }
        if (url == null && (url = ClassLoader.getSystemResource(resourceName)) != null) {
            LOG.debug("Loading configuration from the system classpath (" + resourceName + ")");
        }
        return url;
    }

    static String getBasePath(URL url) {
        if (url == null) {
            return null;
        }
        String s2 = url.toString();
        if (s2.startsWith(FILE_SCHEME) && !s2.startsWith("file://")) {
            s2 = "file://" + s2.substring(FILE_SCHEME.length());
        }
        if (s2.endsWith(RESOURCE_PATH_SEPARATOR) || StringUtils.isEmpty(url.getPath())) {
            return s2;
        }
        return s2.substring(0, s2.lastIndexOf(RESOURCE_PATH_SEPARATOR) + 1);
    }

    static String getFileName(URL url) {
        if (url == null) {
            return null;
        }
        String path = url.getPath();
        if (path.endsWith(RESOURCE_PATH_SEPARATOR) || StringUtils.isEmpty(path)) {
            return null;
        }
        return path.substring(path.lastIndexOf(RESOURCE_PATH_SEPARATOR) + 1);
    }

    public static File getFile(String basePath, String fileName) {
        URL url;
        File f = new File(fileName);
        if (f.isAbsolute()) {
            return f;
        }
        try {
            url = new URL(new URL(basePath), fileName);
        }
        catch (MalformedURLException mex1) {
            try {
                url = new URL(fileName);
            }
            catch (MalformedURLException mex2) {
                url = null;
            }
        }
        if (url != null) {
            return ConfigurationUtils.fileFromURL(url);
        }
        return ConfigurationUtils.constructFile(basePath, fileName);
    }

    public static File fileFromURL(URL url) {
        if (url == null || !url.getProtocol().equals(PROTOCOL_FILE)) {
            return null;
        }
        String filename = url.getFile().replace('/', File.separatorChar);
        int pos = 0;
        while ((pos = filename.indexOf(37, pos)) >= 0) {
            if (pos + 2 >= filename.length()) continue;
            String hexStr = filename.substring(pos + 1, pos + 3);
            char ch = (char)Integer.parseInt(hexStr, 16);
            filename = filename.substring(0, pos) + ch + filename.substring(pos + 3);
        }
        return new File(filename);
    }

    static URL toURL(File file) throws MalformedURLException {
        return file.toURI().toURL();
    }

    public static void enableRuntimeExceptions(Configuration src) {
        if (!(src instanceof EventSource)) {
            throw new IllegalArgumentException("Configuration must be derived from EventSource!");
        }
        ((EventSource)((Object)src)).addErrorListener(new ConfigurationErrorListener(){

            public void configurationError(ConfigurationErrorEvent event) {
                throw new ConfigurationRuntimeException(event.getCause());
            }
        });
    }
}

