/*
 * Decompiled with CFR 0.152.
 */
package org.lable.oss.dynamicconfig.core;

import java.time.Instant;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.function.BiConsumer;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import org.apache.commons.configuration.CombinedConfiguration;
import org.apache.commons.configuration.Configuration;
import org.apache.commons.configuration.HierarchicalConfiguration;
import org.lable.oss.dynamicconfig.core.IncludeReference;

public class ConfigurationComposition {
    Map<String, ConfigReference> allReferences;
    ConfigReference root;
    HierarchicalConfiguration defaultConfiguration;
    private static final String DEFAULT_CONFIG_NAME = "--------";
    public static final String META_MODIFIED_AT = "dc.meta.last-update";
    public static final String META_MODIFIED_TREE = "dc.meta.tree-state";

    public ConfigurationComposition() {
        this(null);
    }

    public ConfigurationComposition(HierarchicalConfiguration defaultConfiguration) {
        this.reset(defaultConfiguration);
    }

    public void reset(HierarchicalConfiguration defaultConfiguration) {
        this.allReferences = new HashMap<String, ConfigReference>();
        this.defaultConfiguration = defaultConfiguration;
        this.root = null;
    }

    void setRootReference(ConfigReference rootReference) {
        this.extendFromDefaults(rootReference);
        this.root = rootReference;
    }

    synchronized ConfigReference updateReferences(String name, List<IncludeReference> newReferences) {
        ConfigReference current = this.allReferences.computeIfAbsent(name, ConfigReference::new);
        Set<ConfigReference> dereferenced = current.unlinkAllReferences();
        newReferences.stream().peek(ir -> {
            if (ir.getName().startsWith("/")) {
                ir.setName(ir.getName().substring(1));
            }
        }).filter(ir -> !current.hasReferenceInChain(ir.getName())).forEach(ir -> {
            ConfigReference referencee = this.allReferences.computeIfAbsent(ir.getName(), ConfigReference::new);
            current.addReciprocalReference((IncludeReference)ir, referencee);
            this.allReferences.put(referencee.getName(), referencee);
            dereferenced.remove(referencee);
        });
        Set<ConfigReference> orphans = this.findDereferencedConfigReferences(dereferenced);
        orphans.forEach(ConfigReference::markAsOrphaned);
        if (current == this.root) {
            this.extendFromDefaults(current);
        }
        return current;
    }

    synchronized void setConfigurationOnReference(ConfigReference reference, HierarchicalConfiguration configuration) {
        reference.setConfiguration(configuration);
        reference.markTimeOfUpdate();
    }

    synchronized ConfigReference markReferenceAsFailedToLoad(String name) {
        ConfigReference current = this.allReferences.computeIfAbsent(name, ConfigReference::new);
        current.markAsFailedToLoad();
        return current;
    }

    synchronized void markReferenceAsNeedsLoading(String name) {
        ConfigReference current = this.allReferences.computeIfAbsent(name, ConfigReference::new);
        current.markAsNeedsLoading();
    }

    synchronized boolean hasMatchingReference(String name, Predicate<ConfigReference> filter) {
        return this.allReferences.containsKey(name) && filter.test(this.allReferences.get(name));
    }

    synchronized ConfigReference getReference(String name) {
        return this.allReferences.get(name);
    }

    synchronized List<ConfigReference> getReferences(Predicate<ConfigReference> filter) {
        return this.allReferences.values().stream().filter(filter).collect(Collectors.toList());
    }

    public synchronized void getRidOfOrphans() {
        this.allReferences.values().removeIf(ref -> ref.getConfigState() == ConfigState.ORPHANED);
    }

    public synchronized void assembleConfigTree(CombinedConfiguration combinedConfig) {
        combinedConfig.clear();
        this.assembleConfigSection(combinedConfig);
        this.setMetadata(combinedConfig);
    }

    void assembleConfigSection(CombinedConfiguration combinedConfig) {
        this.walk((path, ref) -> {
            String name = (path == null ? "" : path) + "->" + ref.getName();
            if (ref.configuration != null) {
                combinedConfig.addConfiguration(ref.configuration, name, (String)path);
            }
        });
    }

    void setMetadata(Configuration combinedConfig) {
        combinedConfig.setProperty(META_MODIFIED_AT, Instant.now().toString());
        StringBuilder builder = new StringBuilder();
        this.walk((path, ref) -> {
            if (path == null && ref.getName().equals(DEFAULT_CONFIG_NAME)) {
                return;
            }
            String name = (path == null ? "." : path) + " -> " + ref.getName();
            builder.append(name);
            builder.append(" ".repeat(Math.max(0, 60 - name.length())));
            String updated = ref.getLastUpdated().map(Instant::toString).orElse("-");
            builder.append(" (").append((Object)ref.configState).append(" @ ").append(updated).append(")\n");
        });
        combinedConfig.setProperty(META_MODIFIED_TREE, builder.toString());
    }

    void walk(BiConsumer<String, ConfigReference> referenceConsumer) {
        this.walk(null, this.root, referenceConsumer);
    }

    void walk(String path, ConfigReference configReference, BiConsumer<String, ConfigReference> referenceConsumer) {
        referenceConsumer.accept(path, configReference);
        configReference.referencedByMe.forEach((includeReference, reference) -> {
            if (includeReference.getConfigPath() == null) {
                return;
            }
            String newPath = path == null ? includeReference.getConfigPath() : path + "." + includeReference.getConfigPath();
            this.walk(newPath, (ConfigReference)reference, referenceConsumer);
        });
        configReference.referencedByMe.forEach((includeReference, reference) -> {
            if (includeReference.getConfigPath() != null) {
                return;
            }
            this.walk(path, (ConfigReference)reference, referenceConsumer);
        });
    }

    void extendFromDefaults(ConfigReference reference) {
        if (this.defaultConfiguration == null) {
            return;
        }
        ConfigReference defaults = this.allReferences.computeIfAbsent(DEFAULT_CONFIG_NAME, ConfigReference::new);
        defaults.setConfiguration(this.defaultConfiguration);
        IncludeReference ir = new IncludeReference(DEFAULT_CONFIG_NAME);
        reference.addReciprocalReference(ir, defaults);
    }

    Set<ConfigReference> findDereferencedConfigReferences(Collection<ConfigReference> potentialOrphans) {
        potentialOrphans.removeIf(reference -> !reference.referencingMe.isEmpty());
        potentialOrphans.removeIf(reference -> reference.getName().equals(this.root.getName()));
        HashSet<ConfigReference> orphans = new HashSet<ConfigReference>(potentialOrphans);
        for (ConfigReference orphan : potentialOrphans) {
            Set<ConfigReference> formerReferencesOfOrphan = orphan.unlinkAllReferences();
            orphans.addAll(this.findDereferencedConfigReferences(formerReferencesOfOrphan));
        }
        return orphans;
    }

    public String toString() {
        if (this.root == null) {
            return "(empty)";
        }
        StringBuilder builder = new StringBuilder();
        this.nodeToString(builder, this.root, 0);
        return builder.toString();
    }

    private void nodeToString(StringBuilder builder, ConfigReference node, int depth) {
        builder.append("  ".repeat(Math.max(0, depth)));
        builder.append(node.getName()).append('\n');
        for (ConfigReference reference : node.referencedByMe.values()) {
            this.nodeToString(builder, reference, depth + 1);
        }
    }

    static enum ConfigState {
        NEEDS_LOADING("PENDING"),
        LOADED("OK"),
        FAILED_TO_LOAD("FAILED"),
        ORPHANED("ORPHANED");

        private final String state;

        private ConfigState(String state) {
            this.state = state;
        }

        public String toString() {
            return this.state;
        }
    }

    static class ConfigReference {
        Set<ConfigReference> referencingMe;
        Map<IncludeReference, ConfigReference> referencedByMe;
        String name;
        ConfigState configState;
        Instant lastUpdated;
        HierarchicalConfiguration configuration;

        ConfigReference(String name) {
            this.name = name;
            this.referencedByMe = new HashMap<IncludeReference, ConfigReference>();
            this.referencingMe = new HashSet<ConfigReference>();
            this.configState = ConfigState.NEEDS_LOADING;
            this.configuration = null;
            this.lastUpdated = null;
        }

        void addReciprocalReference(IncludeReference includeReference, ConfigReference referencee) {
            this.referencedByMe.put(includeReference, referencee);
            referencee.referencingMe.add(this);
        }

        void removeReferenceToMe(ConfigReference referencer) {
            this.referencingMe.remove(referencer);
        }

        void stopReferencing(ConfigReference referencee) {
            this.referencedByMe.values().remove(referencee);
        }

        Set<ConfigReference> unlinkAllReferences() {
            HashSet<ConfigReference> unlinkedReferences = new HashSet<ConfigReference>();
            this.referencedByMe.values().stream().distinct().forEach(referencee -> {
                unlinkedReferences.add((ConfigReference)referencee);
                referencee.removeReferenceToMe(this);
            });
            this.referencedByMe.clear();
            return unlinkedReferences;
        }

        public String getName() {
            return this.name;
        }

        void setConfiguration(HierarchicalConfiguration configuration) {
            this.configuration = configuration;
            this.configState = ConfigState.LOADED;
        }

        void markTimeOfUpdate() {
            this.lastUpdated = Instant.now();
        }

        void markAsFailedToLoad() {
            this.configState = ConfigState.FAILED_TO_LOAD;
        }

        void markAsNeedsLoading() {
            this.configState = ConfigState.NEEDS_LOADING;
        }

        void markAsOrphaned() {
            this.configState = ConfigState.ORPHANED;
        }

        public ConfigState getConfigState() {
            return this.configState;
        }

        public Optional<Instant> getLastUpdated() {
            return Optional.ofNullable(this.lastUpdated);
        }

        boolean hasReferenceInChain(String name) {
            if (this.name.equals(name)) {
                return true;
            }
            for (ConfigReference configReference : this.referencingMe) {
                if (!configReference.hasReferenceInChain(name)) continue;
                return true;
            }
            return false;
        }

        public String toString() {
            StringBuilder builder = new StringBuilder(this.name);
            builder.append(", includes: ");
            if (this.referencedByMe.isEmpty()) {
                builder.append(" -");
            } else {
                builder.append(this.referencedByMe.values().stream().map(ConfigReference::getName).collect(Collectors.joining(", ")));
            }
            return builder.toString();
        }
    }
}

