/*
 * Decompiled with CFR 0.152.
 */
package org.lable.oss.dynamicconfig.core;

import java.io.InputStream;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.ServiceLoader;
import org.apache.commons.configuration.BaseConfiguration;
import org.apache.commons.configuration.CombinedConfiguration;
import org.apache.commons.configuration.Configuration;
import org.apache.commons.configuration.HierarchicalConfiguration;
import org.apache.commons.configuration.tree.OverrideCombiner;
import org.lable.oss.dynamicconfig.core.ConfigChangeListener;
import org.lable.oss.dynamicconfig.core.ConfigurationComposition;
import org.lable.oss.dynamicconfig.core.ConfigurationException;
import org.lable.oss.dynamicconfig.core.ConfigurationManager;
import org.lable.oss.dynamicconfig.core.ConfigurationResult;
import org.lable.oss.dynamicconfig.core.IncludeReference;
import org.lable.oss.dynamicconfig.core.InstanceLocalSettings;
import org.lable.oss.dynamicconfig.core.commonsconfiguration.ConcurrentConfiguration;
import org.lable.oss.dynamicconfig.core.spi.ConfigurationConnection;
import org.lable.oss.dynamicconfig.core.spi.ConfigurationSource;
import org.lable.oss.dynamicconfig.core.spi.HierarchicalConfigurationDeserializer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ConfigurationLoader {
    private static final Logger logger = LoggerFactory.getLogger(ConfigurationLoader.class);
    public static final String LIBRARY_PREFIX = "org.lable.oss.dynamicconfig";
    public static final String APPNAME_PROPERTY = "appname";
    public static final String ROOTCONFIG_PROPERTY = "rootconfig";
    static final String[] COMMON_PROPERTIES = new String[]{"appname", "rootconfig"};
    static ConfigurationComposition composition;

    public static ConfigurationManager configureFromProperties(HierarchicalConfigurationDeserializer deserializer) throws ConfigurationException {
        return ConfigurationLoader.configureFromProperties(null, deserializer);
    }

    public static ConfigurationManager configureFromProperties(HierarchicalConfiguration defaults, HierarchicalConfigurationDeserializer deserializer) throws ConfigurationException {
        return ConfigurationLoader.configureFromProperties(null, defaults, deserializer);
    }

    public static ConfigurationManager configureFromProperties(String sourceType, HierarchicalConfiguration defaults, HierarchicalConfigurationDeserializer deserializer) throws ConfigurationException {
        if (sourceType == null && (sourceType = System.getProperty("org.lable.oss.dynamicconfig.type")) == null) {
            throw new ConfigurationException("System property org.lable.oss.dynamicconfig.type is not set.");
        }
        ConfigurationSource desiredSource = ConfigurationLoader.sourceFromString(sourceType);
        Configuration sourceConfiguration = ConfigurationLoader.gatherPropertiesFor(desiredSource, deserializer);
        return ConfigurationLoader.initialize(desiredSource, sourceConfiguration, deserializer, defaults);
    }

    public static ConfigurationManager fromTheseSettings(String rootConfig, String appName, ConfigurationSource configurationSource, HierarchicalConfigurationDeserializer deserializer, Configuration sourceConfiguration, HierarchicalConfiguration defaults) throws ConfigurationException {
        sourceConfiguration.setProperty(ROOTCONFIG_PROPERTY, rootConfig);
        sourceConfiguration.setProperty(APPNAME_PROPERTY, appName);
        return ConfigurationLoader.initialize(configurationSource, sourceConfiguration, deserializer, defaults);
    }

    static ConfigurationManager initialize(ConfigurationSource desiredSource, Configuration sourceConfiguration, HierarchicalConfigurationDeserializer deserializer, HierarchicalConfiguration defaults) throws ConfigurationException {
        HierarchicalConfiguration effectiveDefaults = defaults == null ? new HierarchicalConfiguration() : defaults;
        String rootConfigName = sourceConfiguration.getString(ROOTCONFIG_PROPERTY);
        CombinedConfiguration allConfig = new CombinedConfiguration(new OverrideCombiner());
        ConcurrentConfiguration concurrentConfiguration = new ConcurrentConfiguration(allConfig);
        composition = new ConfigurationComposition(effectiveDefaults);
        ConfigChangeListener configChangeListener = (connection, name) -> {
            logger.info("New runtime configuration received for configuration part {}.", (Object)name);
            composition.markReferenceAsNeedsLoading(name);
            ConfigurationLoader.load(name, connection, deserializer, composition);
            concurrentConfiguration.withConfiguration(composition::assembleConfigTree);
            composition.getReferences(ref -> ref.getConfigState() == ConfigurationComposition.ConfigState.ORPHANED).forEach(ref -> connection.stopListening(ref.getName()));
            composition.getRidOfOrphans();
        };
        logger.info("Root config: {}.", (Object)rootConfigName);
        String normalizedConfigName = desiredSource.normalizeRootConfigName(rootConfigName);
        desiredSource.configure(sourceConfiguration, effectiveDefaults);
        ConfigLoader loader = () -> {
            composition.reset(effectiveDefaults);
            ConfigurationConnection configurationConnection = desiredSource.connect(configChangeListener);
            ConfigurationComposition.ConfigReference rootReference = ConfigurationLoader.load(normalizedConfigName, configurationConnection, deserializer, composition);
            composition.setRootReference(rootReference);
            concurrentConfiguration.withConfiguration(composition::assembleConfigTree);
            return configurationConnection;
        };
        ConfigurationConnection configurationConnection = loader.connectAndLoad();
        return new ConfigurationManager(concurrentConfiguration, loader, configurationConnection);
    }

    static ConfigurationSource sourceFromString(String desiredSourceName) throws ConfigurationException {
        ServiceLoader<ConfigurationSource> loader = ServiceLoader.load(ConfigurationSource.class);
        for (ConfigurationSource source : loader) {
            if (!source.name().equals(desiredSourceName)) continue;
            return source;
        }
        throw new ConfigurationException("Could not find a ConfigurationSource with name " + desiredSourceName);
    }

    static ConfigurationComposition.ConfigReference load(String name, ConfigurationConnection configurationConnection, HierarchicalConfigurationDeserializer deserializer, ConfigurationComposition composition) {
        ConfigurationResult result;
        if (composition.hasMatchingReference(name, ref -> ref.getConfigState() != ConfigurationComposition.ConfigState.NEEDS_LOADING)) {
            return composition.getReference(name);
        }
        try {
            InputStream is = configurationConnection.load(name);
            result = deserializer.deserialize(is);
        }
        catch (ConfigurationException e) {
            logger.error("Failed to (re)load (part of) configuration: {}.", (Object)name);
            return composition.markReferenceAsFailedToLoad(name);
        }
        configurationConnection.listen(name);
        List<IncludeReference> includeReferences = result.getIncludeReferences();
        ConfigurationLoader.makeReferencesAbsolute(name, includeReferences);
        logger.info("Configuration part (re)loaded ({}).", (Object)name);
        ConfigurationComposition.ConfigReference reference = composition.updateReferences(name, includeReferences);
        composition.setConfigurationOnReference(reference, result.getConfiguration());
        composition.getReferences(ref -> ref.getConfigState() == ConfigurationComposition.ConfigState.NEEDS_LOADING).forEach(ref -> ConfigurationLoader.load(ref.getName(), configurationConnection, deserializer, composition));
        return reference;
    }

    static void makeReferencesAbsolute(String name, List<IncludeReference> includeReferences) {
        String baseDir = name.contains("/") ? name.substring(0, name.lastIndexOf(47) + 1) : "";
        Iterator<IncludeReference> iterator = includeReferences.iterator();
        while (iterator.hasNext()) {
            IncludeReference reference = iterator.next();
            Object refName = reference.getName();
            refName = ((String)refName).startsWith("/") ? ((String)refName).substring(1) : baseDir + (String)refName;
            if ((refName = ConfigurationLoader.solveDots((String)refName)) == null) {
                logger.error("Illegal configuration include reference ({}); ignored.", (Object)reference.getName());
                iterator.remove();
                continue;
            }
            reference.setName("/" + (String)refName);
        }
    }

    static String solveDots(String path) {
        if (!path.contains(".")) {
            return path;
        }
        String[] parts = path.split("/");
        ArrayDeque<String> pathStack = new ArrayDeque<String>();
        String[] stringArray = parts;
        int n = stringArray.length;
        block8: for (int i = 0; i < n; ++i) {
            String part;
            switch (part = stringArray[i]) {
                case ".": {
                    continue block8;
                }
                case "..": {
                    if (pathStack.isEmpty()) {
                        return null;
                    }
                    pathStack.removeLast();
                    continue block8;
                }
                default: {
                    pathStack.addLast(part);
                }
            }
        }
        return String.join((CharSequence)"/", pathStack);
    }

    static Configuration gatherPropertiesFor(ConfigurationSource desiredSource, HierarchicalConfigurationDeserializer deserializer) {
        BaseConfiguration configuration = new BaseConfiguration();
        for (String propertyName : desiredSource.systemProperties()) {
            String value = System.getProperty("org.lable.oss.dynamicconfig." + desiredSource.name() + "." + propertyName);
            if (value == null || value.isEmpty()) continue;
            configuration.setProperty(propertyName, value);
        }
        if (InstanceLocalSettings.INSTANCE.getAppName() != null) {
            configuration.setProperty(APPNAME_PROPERTY, InstanceLocalSettings.INSTANCE.getAppName());
        }
        for (String propertyName : COMMON_PROPERTIES) {
            String value = System.getProperty("org.lable.oss.dynamicconfig." + propertyName);
            if (value == null || value.isEmpty()) continue;
            configuration.setProperty(propertyName, value);
        }
        if (configuration.getString(ROOTCONFIG_PROPERTY) == null) {
            String fallback = configuration.getString(APPNAME_PROPERTY, deserializer.defaultConfigName());
            configuration.setProperty(ROOTCONFIG_PROPERTY, fallback);
        }
        return configuration;
    }

    static List<ConfigurationSource> detectConfigurationSourceServiceProviders() {
        ArrayList<ConfigurationSource> providers = new ArrayList<ConfigurationSource>();
        ServiceLoader<ConfigurationSource> loader = ServiceLoader.load(ConfigurationSource.class);
        for (ConfigurationSource source : loader) {
            providers.add(source);
        }
        return providers;
    }

    @FunctionalInterface
    public static interface ConfigLoader {
        public ConfigurationConnection connectAndLoad() throws ConfigurationException;
    }
}

