/*
 * Decompiled with CFR 0.152.
 */
package org.lable.oss.dynamicconfig.core;

import java.io.Closeable;
import java.io.IOException;
import org.apache.commons.configuration.Configuration;
import org.lable.oss.dynamicconfig.core.ConfigurationException;
import org.lable.oss.dynamicconfig.core.ConfigurationLoader;
import org.lable.oss.dynamicconfig.core.spi.ConfigurationConnection;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ConfigurationManager
implements Closeable {
    private static final Logger logger = LoggerFactory.getLogger(ConfigurationManager.class);
    private final Configuration configuration;
    private final ConfigurationLoader.ConfigLoader reloader;
    private ConfigurationConnection configurationConnection;

    public ConfigurationManager(Configuration configuration, ConfigurationLoader.ConfigLoader reloader, ConfigurationConnection configurationConnection) {
        this.configuration = configuration;
        this.reloader = reloader;
        this.configurationConnection = configurationConnection;
    }

    public Configuration getConfiguration() {
        return this.configuration;
    }

    public void reload() throws ConfigurationException {
        try {
            this.close();
        }
        catch (IOException e) {
            logger.warn("Failed to close configuration connection properly.", e);
        }
        this.configurationConnection = this.reloader.connectAndLoad();
    }

    @Override
    public void close() throws IOException {
        this.configurationConnection.close();
    }
}

