/*
 * Decompiled with CFR 0.152.
 */
package org.lable.oss.dynamicconfig.core;

import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Collectors;

public enum InstanceLocalSettings {
    INSTANCE;

    private String name = null;
    private String rootPath;
    private Map<MetaDataKey, String> metaData = new HashMap<MetaDataKey, String>();

    public void setAppName(String name) {
        this.name = name;
    }

    public String getAppName() {
        return this.name;
    }

    public void setRootPath(String rootPath) {
        this.rootPath = rootPath;
    }

    public String getRootPath() {
        return this.rootPath;
    }

    public void setMetaData(String category, String key, String value) {
        this.metaData.put(new MetaDataKey(category, key), value);
    }

    public Optional<String> getMetaData(String category, String key) {
        MetaDataKey mdk = new MetaDataKey(category, key);
        return Optional.ofNullable(this.metaData.get(mdk));
    }

    public Map<MetaDataKey, String> getMetaData(String category) {
        return this.metaData.entrySet().stream().filter(entry -> ((MetaDataKey)entry.getKey()).getCategory().equals(category)).collect(Collectors.toMap(Map.Entry::getKey, Map.Entry::getValue));
    }

    public Map<MetaDataKey, String> getMetaData() {
        return this.metaData;
    }

    public static class MetaDataKey {
        private String category;
        private String key;

        MetaDataKey(String category, String key) {
            if (category == null) {
                throw new IllegalArgumentException("Category may not be null.");
            }
            if (key == null) {
                throw new IllegalArgumentException("Key may not be null.");
            }
            this.category = category;
            this.key = key;
        }

        public String getCategory() {
            return this.category;
        }

        public String getKey() {
            return this.key;
        }

        public int hashCode() {
            return Objects.hash(this.category, this.key);
        }

        public boolean equals(Object other) {
            if (!(other instanceof MetaDataKey)) {
                return false;
            }
            MetaDataKey that = (MetaDataKey)other;
            return Objects.equals(this.category, that.category) && Objects.equals(this.key, that.key);
        }

        public String toString() {
            return this.category + ":" + this.key;
        }
    }
}

