/*
 * Decompiled with CFR 0.152.
 */
package org.lable.oss.dynamicconfig.provider;

import java.io.IOException;
import java.io.InputStream;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.TimeUnit;
import org.lable.oss.dynamicconfig.core.ConfigChangeListener;
import org.lable.oss.dynamicconfig.core.ConfigurationException;
import org.lable.oss.dynamicconfig.core.spi.ConfigurationConnection;
import org.lable.oss.dynamicconfig.provider.file.FileWatcher;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FileBasedConfigConnection
implements ConfigurationConnection {
    private static final Logger logger = LoggerFactory.getLogger(FileBasedConfigConnection.class);
    private final Path rootDir;
    private final ConfigChangeListener changeListener;
    private final FileWatcher fileWatcher;
    private final ExecutorService executorService;
    private final Map<Path, String> pathNameMapping = new HashMap<Path, String>();

    public FileBasedConfigConnection(Path rootDir, ConfigChangeListener changeListener) throws ConfigurationException {
        this.rootDir = rootDir;
        this.changeListener = changeListener;
        if (changeListener != null) {
            try {
                this.fileWatcher = new FileWatcher(this::handleFileChanged, rootDir);
            }
            catch (IOException e) {
                throw new ConfigurationException(e);
            }
            this.executorService = Executors.newSingleThreadExecutor();
            this.executorService.execute(this.fileWatcher);
        } else {
            this.fileWatcher = null;
            this.executorService = null;
        }
    }

    @Override
    public void listen(String name) {
        if (this.changeListener != null) {
            this.fileWatcher.listen(Paths.get(name, new String[0]));
        }
    }

    @Override
    public void stopListening(String name) {
        if (this.changeListener != null) {
            this.fileWatcher.stopListening(Paths.get(name, new String[0]));
        }
    }

    @Override
    public InputStream load(String name) throws ConfigurationException {
        if (name == null || name.isEmpty()) {
            throw new ConfigurationException("name", "Configuration part name cannot be null or empty.");
        }
        Path filePath = this.rootDir.resolve(name);
        this.pathNameMapping.put(filePath, name);
        try {
            return Files.newInputStream(filePath, new OpenOption[0]);
        }
        catch (IOException e) {
            throw new ConfigurationException("Failed to find configuration part in file " + filePath + ".", e);
        }
    }

    void handleFileChanged(FileWatcher.Event event, Path filePath) {
        switch (event) {
            case FILE_CREATED: 
            case FILE_MODIFIED: {
                String mutation = event == FileWatcher.Event.FILE_CREATED ? "(re)created" : "modified";
                logger.info("Configuration part file {}, reloading configuration.", (Object)mutation);
                Path relativeToRootDir = this.rootDir.resolve(filePath);
                String name = this.pathNameMapping.putIfAbsent(relativeToRootDir, relativeToRootDir.toString());
                this.changeListener.changed(this, name);
                break;
            }
            case FILE_DELETED: {
                logger.warn("Configuration part file {} was deleted. Its contents will be kept in configuration memory until a new file replaces it, or if no other configuration reference it.", (Object)filePath);
                break;
            }
        }
    }

    @Override
    public void close() throws IOException {
        if (this.fileWatcher != null) {
            this.fileWatcher.close();
        }
        if (this.executorService != null) {
            this.executorService.shutdown();
            try {
                boolean bl = this.executorService.awaitTermination(2L, TimeUnit.SECONDS);
            }
            catch (InterruptedException e) {
                Thread.currentThread().interrupt();
            }
        }
    }
}

