/*
 * Decompiled with CFR 0.152.
 */
package org.lable.oss.dynamicconfig.provider;

import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import org.apache.commons.configuration.Configuration;
import org.lable.oss.dynamicconfig.core.ConfigChangeListener;
import org.lable.oss.dynamicconfig.core.ConfigurationException;
import org.lable.oss.dynamicconfig.core.spi.ConfigurationConnection;
import org.lable.oss.dynamicconfig.core.spi.ConfigurationSource;
import org.lable.oss.dynamicconfig.provider.FileBasedConfigConnection;

public class FileBasedConfigSource
implements ConfigurationSource {
    private Path rootDir;

    @Override
    public String name() {
        return "file";
    }

    @Override
    public void configure(Configuration configuration, Configuration defaults) throws ConfigurationException {
        String rootConfigFile = configuration.getString("rootconfig");
        if (rootConfigFile == null) {
            throw new ConfigurationException("Parameter rootconfig not set.");
        }
        this.rootDir = Paths.get(rootConfigFile, new String[0]).getParent();
        if (this.rootDir == null || !Files.isDirectory(this.rootDir, new LinkOption[0])) {
            throw new ConfigurationException("Parameter configDir is not a directory (" + rootConfigFile + ").");
        }
    }

    @Override
    public ConfigurationConnection connect(ConfigChangeListener changeListener) throws ConfigurationException {
        return new FileBasedConfigConnection(this.rootDir, changeListener);
    }

    @Override
    public String normalizeRootConfigName(String rootConfigName) {
        Path path = Paths.get(rootConfigName, new String[0]);
        return path.getFileName().toString();
    }
}

