/*
 * Decompiled with CFR 0.152.
 */
package org.lable.oss.dynamicconfig.provider.etcd;

import io.etcd.jetcd.ByteSequence;
import io.etcd.jetcd.Client;
import io.etcd.jetcd.KeyValue;
import io.etcd.jetcd.Watch;
import io.etcd.jetcd.kv.GetResponse;
import io.etcd.jetcd.watch.WatchEvent;
import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.nio.charset.StandardCharsets;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.TimeUnit;
import org.lable.oss.dynamicconfig.core.ConfigChangeListener;
import org.lable.oss.dynamicconfig.core.ConfigurationException;
import org.lable.oss.dynamicconfig.core.spi.ConfigurationConnection;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class EtcdAsConfigConnection
implements ConfigurationConnection {
    private static final Logger logger = LoggerFactory.getLogger(EtcdAsConfigConnection.class);
    private final Client etcd;
    private final String namespace;
    private final ExecutorService executor;
    private final ConfigChangeListener changeListener;
    private final Map<String, Watch.Watcher> watches = new HashMap<String, Watch.Watcher>();
    private boolean stopped = false;

    public EtcdAsConfigConnection(String[] cluster, String namespace, ConfigChangeListener changeListener) {
        this.namespace = namespace;
        this.changeListener = changeListener;
        this.etcd = Client.builder().endpoints(cluster).loadBalancerPolicy("round_robin").namespace(ByteSequence.from(namespace, StandardCharsets.UTF_8)).build();
        this.executor = Executors.newSingleThreadExecutor();
    }

    @Override
    public void listen(String name) {
        if (this.stopped) {
            return;
        }
        if (this.watches.containsKey(name)) {
            return;
        }
        logger.info("Setting watcher on key {}.", (Object)name);
        Watch.Watcher watcher = this.etcd.getWatchClient().watch(EtcdAsConfigConnection.nameToByteSequence(name), watchResponse -> {
            List<WatchEvent> events = watchResponse.getEvents();
            for (WatchEvent event : events) {
                KeyValue kv = event.getKeyValue();
                if (!kv.getKey().toString(StandardCharsets.UTF_8).equals(name)) continue;
                switch (event.getEventType()) {
                    case PUT: {
                        this.executor.submit(() -> this.changeListener.changed(this, name));
                        break;
                    }
                    case DELETE: {
                        logger.error("Configuration key {} deleted. Waiting for it to be recreated\u2026", (Object)name);
                        break;
                    }
                }
            }
        });
        this.watches.put(name, watcher);
    }

    @Override
    public void stopListening(String name) {
        logger.info("Removing watcher from key {}.", (Object)name);
        this.watches.remove(name).close();
    }

    @Override
    public InputStream load(String name) throws ConfigurationException {
        GetResponse getResponse;
        if (this.stopped) {
            throw new ConfigurationException("Refusing to load config because this class is being shut down.");
        }
        try {
            getResponse = this.etcd.getKVClient().get(EtcdAsConfigConnection.nameToByteSequence(name)).get();
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            throw new ConfigurationException(e);
        }
        catch (ExecutionException e) {
            throw new ConfigurationException("Failed to load key " + this.namespace + name + ".", e);
        }
        if (getResponse.getCount() == 0L) {
            throw new ConfigurationException("No such key in etcd: " + this.namespace + name + ".");
        }
        return new ByteArrayInputStream(getResponse.getKvs().get(0).getValue().getBytes());
    }

    @Override
    public void close() {
        this.stopped = true;
        try {
            this.watches.values().forEach(Watch.Watcher::close);
            this.executor.shutdown();
            boolean terminated = this.executor.awaitTermination(5L, TimeUnit.SECONDS);
            if (!terminated) {
                logger.error("Failed to terminate the change-listeners.");
            }
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
        }
        this.etcd.close();
    }

    static ByteSequence nameToByteSequence(String name) {
        return ByteSequence.from(name, StandardCharsets.UTF_8);
    }
}

