/*
 * Decompiled with CFR 0.152.
 */
package org.lable.oss.dynamicconfig.provider.etcd;

import java.util.Arrays;
import java.util.List;
import org.apache.commons.configuration.Configuration;
import org.lable.oss.dynamicconfig.core.ConfigChangeListener;
import org.lable.oss.dynamicconfig.core.ConfigurationException;
import org.lable.oss.dynamicconfig.core.spi.ConfigurationConnection;
import org.lable.oss.dynamicconfig.core.spi.ConfigurationSource;
import org.lable.oss.dynamicconfig.provider.etcd.EtcdAsConfigConnection;

public class EtcdAsConfigSource
implements ConfigurationSource {
    private String namespace;
    private String[] cluster;

    public String name() {
        return "etcd";
    }

    public List<String> systemProperties() {
        return Arrays.asList("cluster", "namespace", "copy.cluster.to");
    }

    public void configure(Configuration configuration, Configuration defaults) throws ConfigurationException {
        String namespace = configuration.getString("namespace");
        String[] cluster = configuration.getStringArray("cluster");
        String copyClusterTo = configuration.getString("copy.cluster.to");
        String rootConfig = configuration.getString("rootconfig");
        if (cluster.length == 0) {
            throw new ConfigurationException("cluster", "No Etcd cluster endpoints specified.");
        }
        if (namespace == null || namespace.isEmpty()) {
            throw new ConfigurationException("namespace", "No namespace specified.");
        }
        if (rootConfig == null || rootConfig.isEmpty()) {
            throw new ConfigurationException("appname", "No application name found.");
        }
        if (copyClusterTo != null) {
            defaults.setProperty(copyClusterTo, (Object)cluster);
        }
        this.namespace = namespace;
        this.cluster = cluster;
    }

    public ConfigurationConnection connect(ConfigChangeListener changeListener) throws ConfigurationException {
        return new EtcdAsConfigConnection(this.cluster, this.namespace, changeListener);
    }
}

