/*
 * Decompiled with CFR 0.152.
 */
package org.lable.oss.dynamicconfig.provider.zookeeper;

import java.io.IOException;
import java.io.InputStream;
import java.util.Arrays;
import java.util.List;
import java.util.Optional;
import org.apache.commons.configuration.Configuration;
import org.lable.oss.dynamicconfig.core.ConfigChangeListener;
import org.lable.oss.dynamicconfig.core.ConfigurationException;
import org.lable.oss.dynamicconfig.core.spi.ConfigurationSource;
import org.lable.oss.dynamicconfig.zookeeper.MonitoringZookeeperConnection;

public class ZookeepersAsConfigSource
implements ConfigurationSource {
    String[] quorum;
    String copyQuorumTo;
    MonitoringZookeeperConnection zookeeperConnection;

    public String name() {
        return "zookeeper";
    }

    public List<String> systemProperties() {
        return Arrays.asList("quorum", "znode", "copy.quorum.to");
    }

    public void configure(Configuration configuration, Configuration defaults, ConfigChangeListener changeListener) throws ConfigurationException {
        String[] quorum = configuration.getStringArray("quorum");
        String znode = configuration.getString("znode");
        String copyQuorumTo = configuration.getString("copy.quorum.to");
        String rootConfig = configuration.getString("rootconfig");
        if (quorum.length == 0) {
            throw new ConfigurationException("quorum", "No ZooKeeper quorum specified.");
        }
        if (znode == null || znode.isEmpty()) {
            throw new ConfigurationException("znode", "No znode specified.");
        }
        if (rootConfig == null || rootConfig.isEmpty()) {
            throw new ConfigurationException("appname", "No application name found.");
        }
        if (copyQuorumTo != null) {
            this.copyQuorumTo = copyQuorumTo;
            defaults.setProperty(copyQuorumTo, (Object)quorum);
        }
        this.quorum = quorum;
        this.zookeeperConnection = new MonitoringZookeeperConnection(quorum, znode, (name, inputStream) -> {
            if (!name.startsWith("/")) {
                name = "/" + name;
            }
            name = ZookeepersAsConfigSource.znodeNameToName(name);
            changeListener.changed(name, inputStream);
        });
    }

    public void listen(String name) {
        String znode = ZookeepersAsConfigSource.nameToZnodeName(name);
        this.zookeeperConnection.listen(znode);
    }

    public void stopListening(String name) {
        String znode = ZookeepersAsConfigSource.nameToZnodeName(name);
        this.zookeeperConnection.stopListening(znode);
    }

    public InputStream load(String name) throws ConfigurationException {
        String znode = ZookeepersAsConfigSource.nameToZnodeName(name);
        Optional is = this.zookeeperConnection.load(znode);
        if (!is.isPresent()) {
            throw new ConfigurationException("Failed to load " + name + ".");
        }
        return (InputStream)is.get();
    }

    public void close() throws IOException {
        this.zookeeperConnection.close();
    }

    static String nameToZnodeName(String name) {
        if (name.startsWith("/")) {
            name = name.substring(1);
        }
        return "/" + name.replace("/", "--");
    }

    static String znodeNameToName(String znode) {
        return znode.substring(1).replace("--", "/");
    }
}

