/*
 * Decompiled with CFR 0.152.
 */
package org.lable.oss.dynamicconfig.provider.zookeeper;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.Arrays;
import java.util.List;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.TimeUnit;
import org.apache.commons.configuration.Configuration;
import org.apache.commons.configuration.ConfigurationException;
import org.apache.commons.configuration.HierarchicalConfiguration;
import org.apache.commons.lang.StringUtils;
import org.apache.zookeeper.AsyncCallback;
import org.apache.zookeeper.KeeperException;
import org.apache.zookeeper.WatchedEvent;
import org.apache.zookeeper.Watcher;
import org.apache.zookeeper.ZooKeeper;
import org.apache.zookeeper.data.Stat;
import org.lable.oss.dynamicconfig.core.ConfigChangeListener;
import org.lable.oss.dynamicconfig.core.spi.ConfigurationSource;
import org.lable.oss.dynamicconfig.core.spi.HierarchicalConfigurationDeserializer;
import org.lable.oss.dynamicconfig.provider.zookeeper.NodeWatcher;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ZookeepersAsConfigSource
implements ConfigurationSource {
    private static final Logger logger = LoggerFactory.getLogger(ZookeepersAsConfigSource.class);
    static int ZOOKEEPER_TIMEOUT = 10;
    String[] quorum;
    String znode;
    String copyQuorumTo;

    public String name() {
        return "zookeeper";
    }

    public List<String> systemProperties() {
        return Arrays.asList("quorum", "znode", "copy.quorum.to");
    }

    public void configure(Configuration configuration) throws org.lable.oss.dynamicconfig.core.ConfigurationException {
        String[] quorum = configuration.getStringArray("quorum");
        String znode = configuration.getString("znode");
        String copyQuorumTo = configuration.getString("copy.quorum.to");
        String appName = configuration.getString("appname");
        if (quorum.length == 0) {
            throw new org.lable.oss.dynamicconfig.core.ConfigurationException("quorum", "No ZooKeeper quorum specified.");
        }
        if (StringUtils.isBlank((String)znode)) {
            throw new org.lable.oss.dynamicconfig.core.ConfigurationException("znode", "No znode specified.");
        }
        if (StringUtils.isBlank((String)appName)) {
            throw new org.lable.oss.dynamicconfig.core.ConfigurationException("appname", "No application name found.");
        }
        if (StringUtils.isNotBlank((String)copyQuorumTo)) {
            this.copyQuorumTo = copyQuorumTo;
        }
        this.quorum = quorum;
        this.znode = ZookeepersAsConfigSource.combinePath(znode, appName);
    }

    public void listen(final HierarchicalConfigurationDeserializer deserializer, final ConfigChangeListener listener) {
        AsyncCallback.DataCallback callback = new AsyncCallback.DataCallback(){

            public void processResult(int rc, String path, Object ctx, byte[] data, Stat stat) {
                HierarchicalConfiguration hc;
                if (stat != null && (hc = ZookeepersAsConfigSource.this.parseData(deserializer, data)) != null) {
                    logger.info("Configuration received from Zookeeper quorum. Znode: " + path);
                    listener.changed(hc);
                }
            }
        };
        Thread watcher = new Thread(new NodeWatcher(StringUtils.join((Object[])this.quorum, (String)","), callback, this.znode));
        watcher.setName("ZooKeeper config watcher, node: " + this.znode);
        watcher.start();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean load(HierarchicalConfigurationDeserializer deserializer, ConfigChangeListener listener) {
        byte[] configData;
        ZooKeeper zookeeper;
        final CountDownLatch latch = new CountDownLatch(1);
        try {
            zookeeper = new ZooKeeper(StringUtils.join((Object[])this.quorum, (String)","), ZOOKEEPER_TIMEOUT * 1000, new Watcher(){

                public void process(WatchedEvent watchedEvent) {
                    if (watchedEvent.getState() == Watcher.Event.KeeperState.SyncConnected) {
                        latch.countDown();
                    }
                }
            });
        }
        catch (IOException e) {
            logger.error("Failed to open a connection to the Zookeeper quorum: " + StringUtils.join((Object[])this.quorum, (String)","), (Throwable)e);
            return false;
        }
        try {
            boolean successfulCountDown = latch.await(ZOOKEEPER_TIMEOUT * 1000 + 300, TimeUnit.MILLISECONDS);
            if (!successfulCountDown) {
                logger.error("Zookeeper connection attempt timed out.");
                boolean bl = false;
                return bl;
            }
            logger.info("Looking at " + this.znode + " for configuration data.");
            configData = zookeeper.getData(this.znode, false, null);
        }
        catch (InterruptedException ie) {
            Thread.currentThread().interrupt();
            boolean bl = false;
            return bl;
        }
        catch (KeeperException e) {
            logger.error("Problem accessing configuration data through Zookeeper quorum.", (Throwable)e);
            boolean bl = false;
            return bl;
        }
        catch (IllegalArgumentException e) {
            logger.error("Path to configuration data in Zookeeper quorum does not make sense: " + this.znode, (Throwable)e);
            boolean bl = false;
            return bl;
        }
        finally {
            try {
                zookeeper.close();
            }
            catch (InterruptedException e) {
                Thread.currentThread().interrupt();
            }
        }
        HierarchicalConfiguration hc = this.parseData(deserializer, configData);
        if (hc == null) {
            return false;
        }
        listener.changed(hc);
        return true;
    }

    HierarchicalConfiguration parseData(HierarchicalConfigurationDeserializer deserializer, byte[] raw) {
        HierarchicalConfiguration hc;
        ByteArrayInputStream bis = new ByteArrayInputStream(raw);
        try {
            hc = deserializer.deserialize((InputStream)bis);
        }
        catch (ConfigurationException e) {
            logger.error("Failed to parse configuration data retrieved from Zookeeper quorum. Raw data:\n\n" + new String(raw) + "\n\n" + e.getCause().getMessage());
            return null;
        }
        if (this.copyQuorumTo != null) {
            hc.setProperty(this.copyQuorumTo, (Object)this.quorum);
        }
        return hc;
    }

    static String combinePath(String znode, String appName) {
        if (!StringUtils.isBlank((String)appName)) {
            if (!znode.substring(znode.length() - 1, znode.length()).equals("/")) {
                znode = znode + "/";
            }
            if (appName.startsWith("/")) {
                appName = appName.substring(1);
            }
            znode = znode + appName;
        }
        return znode;
    }
}

