/*
 * Decompiled with CFR 0.152.
 */
package org.lable.oss.dynamicconfig.provider.zookeeper;

import java.io.Closeable;
import java.io.IOException;
import java.util.concurrent.TimeUnit;
import org.apache.zookeeper.AsyncCallback;
import org.apache.zookeeper.KeeperException;
import org.apache.zookeeper.WatchedEvent;
import org.apache.zookeeper.Watcher;
import org.apache.zookeeper.ZooKeeper;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class NodeWatcher
implements Watcher,
Runnable,
Closeable {
    private static final Logger logger = LoggerFactory.getLogger(NodeWatcher.class);
    static final int MAX_RETRY_WAIT_MINUTES = 5;
    private final AsyncCallback.DataCallback callback;
    private final String quorum;
    private final String path;
    private ZooKeeper zk;
    private int retryCounter;
    private int retryWait;

    public NodeWatcher(String quorum, AsyncCallback.DataCallback callback, String path) {
        this.quorum = quorum;
        this.callback = callback;
        this.path = path;
        this.resetRetryCounters();
        this.connect();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        try {
            NodeWatcher nodeWatcher = this;
            synchronized (nodeWatcher) {
                this.wait();
            }
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void close() throws IOException {
        NodeWatcher nodeWatcher = this;
        synchronized (nodeWatcher) {
            try {
                this.zk.close();
            }
            catch (InterruptedException e) {
                Thread.currentThread().interrupt();
            }
            this.notifyAll();
        }
    }

    public void process(WatchedEvent watchedEvent) {
        Watcher.Event.KeeperState state = watchedEvent.getState();
        Watcher.Event.EventType type = watchedEvent.getType();
        switch (state) {
            case SyncConnected: 
            case ConnectedReadOnly: {
                this.resetRetryCounters();
                switch (type) {
                    case NodeCreated: 
                    case NodeDataChanged: {
                        this.zk.getData(this.path, (Watcher)this, this.callback, null);
                        break;
                    }
                    case None: {
                        this.registerWatcher(this.path);
                        break;
                    }
                    case NodeDeleted: {
                        logger.error("Our configuration znode was deleted. Waiting for it to be recreated\u2026");
                        this.registerWatcher(this.path);
                    }
                }
                break;
            }
            case Disconnected: {
                logger.warn("Disconnected from Zookeeper quorum, reconnecting\u2026");
                this.waitBeforeRetrying();
                break;
            }
            case Expired: {
                logger.warn("Connection to Zookeeper quorum expired. Attempting to reconnect\u2026");
                this.connect();
                break;
            }
        }
    }

    void connect() {
        logger.debug("Connecting to ZooKeeper Quorum.");
        if (this.zk != null) {
            try {
                this.zk.close();
            }
            catch (InterruptedException ie) {
                Thread.currentThread().interrupt();
            }
        }
        if (this.retryCounter > 0) {
            logger.warn("Failed to connect to Zookeeper quorum, retrying (" + this.retryCounter + ").");
        }
        try {
            this.zk = new ZooKeeper(this.quorum, 3000, (Watcher)this);
        }
        catch (IOException e) {
            this.waitBeforeRetrying();
            this.connect();
        }
    }

    void registerWatcher(String path) {
        try {
            this.zk.exists(path, (Watcher)this);
        }
        catch (KeeperException.SessionExpiredException e) {
            this.connect();
        }
        catch (KeeperException e) {
            logger.error("KeeperException caught, retrying\u2026", (Throwable)e);
            this.waitBeforeRetrying();
        }
        catch (InterruptedException ie) {
            Thread.currentThread().interrupt();
        }
    }

    void waitBeforeRetrying() {
        if (this.retryWait < 300) {
            this.retryWait *= 2;
            if (this.retryWait > 300) {
                this.retryWait = 300;
            }
        }
        ++this.retryCounter;
        try {
            logger.info("Failed to connect to ZooKeeper quorum, waiting " + this.retryWait + "s before retrying.");
            TimeUnit.SECONDS.sleep(this.retryWait);
        }
        catch (InterruptedException ie) {
            Thread.currentThread().interrupt();
        }
    }

    void resetRetryCounters() {
        this.retryCounter = 0;
        this.retryWait = 10;
    }
}

