/*
 * Decompiled with CFR 0.152.
 */
package org.lable.oss.dynamicconfig.serialization.yaml;

import java.io.IOException;
import java.io.OutputStream;
import java.io.StringWriter;
import java.io.Writer;
import org.apache.commons.configuration.HierarchicalConfiguration;
import org.apache.commons.configuration.tree.ConfigurationNode;
import org.lable.oss.dynamicconfig.core.ConfigurationException;
import org.lable.oss.dynamicconfig.core.commonsconfiguration.Objectifier;
import org.lable.oss.dynamicconfig.core.spi.HierarchicalConfigurationSerializer;
import org.yaml.snakeyaml.DumperOptions;
import org.yaml.snakeyaml.Yaml;

public class YamlSerializer
implements HierarchicalConfigurationSerializer {
    private final Yaml yaml;

    public YamlSerializer() {
        DumperOptions yamlOptions = new DumperOptions();
        yamlOptions.setIndent(4);
        yamlOptions.setDefaultFlowStyle(DumperOptions.FlowStyle.BLOCK);
        this.yaml = new Yaml(yamlOptions);
    }

    public void serialize(HierarchicalConfiguration configuration, OutputStream output, boolean humanReadable) throws ConfigurationException {
        StringWriter writer = new StringWriter();
        this.yaml.dump(Objectifier.traverseTreeAndEmit((ConfigurationNode)configuration.getRootNode()), (Writer)writer);
        try {
            output.write(writer.toString().getBytes());
        }
        catch (IOException e) {
            throw new ConfigurationException("IOException caught.", (Throwable)e);
        }
    }
}

