/*
 * Decompiled with CFR 0.152.
 */
package org.lable.oss.dynamicconfig.serialization.yaml;

import java.io.InputStream;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Scanner;
import org.apache.commons.configuration.HierarchicalConfiguration;
import org.apache.commons.configuration.tree.ConfigurationNode;
import org.lable.oss.dynamicconfig.core.ConfigurationException;
import org.lable.oss.dynamicconfig.core.ConfigurationResult;
import org.lable.oss.dynamicconfig.core.IncludeReference;
import org.lable.oss.dynamicconfig.core.spi.HierarchicalConfigurationDeserializer;
import org.lable.oss.dynamicconfig.serialization.yaml.snake.CustomConstructor;
import org.yaml.snakeyaml.DumperOptions;
import org.yaml.snakeyaml.Yaml;
import org.yaml.snakeyaml.constructor.BaseConstructor;
import org.yaml.snakeyaml.representer.Representer;

public class YamlDeserializer
implements HierarchicalConfigurationDeserializer {
    private final Yaml yaml;

    public YamlDeserializer() {
        DumperOptions yamlOptions = new DumperOptions();
        Representer representer = new Representer();
        CustomConstructor customConstructor = new CustomConstructor();
        this.yaml = new Yaml((BaseConstructor)customConstructor, representer, yamlOptions);
    }

    public ConfigurationResult deserialize(InputStream input) throws ConfigurationException {
        String content = new Scanner(input, StandardCharsets.UTF_8).useDelimiter("\\A").next();
        HierarchicalConfiguration configuration = new HierarchicalConfiguration();
        ArrayList<IncludeReference> includes = new ArrayList<IncludeReference>();
        if (!content.isEmpty()) {
            Object tree;
            try {
                tree = this.yaml.load(content);
            }
            catch (Throwable e) {
                throw new ConfigurationException("Failed to parse input as valid YAML.", e);
            }
            this.traverseTreeAndLoad(configuration.getRootNode(), null, includes, tree);
            for (String reference : configuration.getStringArray("extends")) {
                includes.add(new IncludeReference(reference));
            }
        }
        return new ConfigurationResult(configuration, includes);
    }

    public String defaultConfigName() {
        return "config.yaml";
    }

    void traverseTreeAndLoad(ConfigurationNode parent, String path, List<IncludeReference> includes, Object node) {
        if (node instanceof IncludeReference) {
            IncludeReference include = (IncludeReference)node;
            include.setConfigPath(path);
            includes.add(include);
        } else if (node instanceof Map) {
            Map map = (Map)node;
            for (Map.Entry entry : map.entrySet()) {
                String key = (String)entry.getKey();
                HierarchicalConfiguration.Node child = new HierarchicalConfiguration.Node(key);
                child.setReference(entry);
                this.traverseTreeAndLoad((ConfigurationNode)child, YamlDeserializer.combineConfigKeyPath(path, key), includes, entry.getValue());
                parent.addChild((ConfigurationNode)child);
            }
        } else {
            parent.setValue(node);
        }
    }

    static String combineConfigKeyPath(String prefix, String name) {
        return prefix == null ? name : prefix + "." + name;
    }
}

