/*
 * Decompiled with CFR 0.152.
 */
package org.lable.oss.dynamicconfig.serialization.yaml;

import java.io.IOException;
import java.io.InputStream;
import java.util.Map;
import org.apache.commons.configuration.ConfigurationException;
import org.apache.commons.configuration.HierarchicalConfiguration;
import org.apache.commons.configuration.tree.ConfigurationNode;
import org.apache.commons.io.IOUtils;
import org.lable.oss.dynamicconfig.core.spi.HierarchicalConfigurationDeserializer;
import org.yaml.snakeyaml.DumperOptions;
import org.yaml.snakeyaml.Yaml;
import org.yaml.snakeyaml.parser.ParserException;

public class YamlDeserializer
implements HierarchicalConfigurationDeserializer {
    private final DumperOptions yamlOptions = new DumperOptions();
    private final Yaml yaml = new Yaml(this.yamlOptions);

    public HierarchicalConfiguration deserialize(InputStream input) throws ConfigurationException {
        Object tree;
        String content;
        try {
            content = IOUtils.toString((InputStream)input);
        }
        catch (IOException e) {
            throw new ConfigurationException("Failed to read from stream.");
        }
        if (content.isEmpty()) {
            return new HierarchicalConfiguration();
        }
        try {
            tree = this.yaml.load(content);
        }
        catch (ParserException e) {
            throw new ConfigurationException("Failed to parse input as valid YAML.", (Throwable)e);
        }
        HierarchicalConfiguration configuration = new HierarchicalConfiguration();
        this.traverseTreeAndLoad(configuration.getRootNode(), tree);
        return configuration;
    }

    void traverseTreeAndLoad(ConfigurationNode parent, Object node) {
        if (node instanceof Map) {
            Map map = (Map)node;
            for (Map.Entry entry : map.entrySet()) {
                HierarchicalConfiguration.Node child = new HierarchicalConfiguration.Node((String)entry.getKey());
                child.setReference(entry);
                this.traverseTreeAndLoad((ConfigurationNode)child, entry.getValue());
                parent.addChild((ConfigurationNode)child);
            }
        } else {
            parent.setValue(node);
        }
    }
}

