/*
 * Decompiled with CFR 0.152.
 */
package org.lable.oss.dynamicconfig.zookeeper;

import java.util.ArrayList;
import java.util.List;
import org.apache.zookeeper.CreateMode;
import org.apache.zookeeper.KeeperException;
import org.apache.zookeeper.ZooDefs;
import org.apache.zookeeper.ZooKeeper;
import org.apache.zookeeper.data.Stat;

public class ZooKeeperHelper {
    static void mkdirp(ZooKeeper zookeeper, String znode) throws KeeperException, InterruptedException {
        boolean createPath = false;
        for (String path : ZooKeeperHelper.pathParts(znode)) {
            Stat stat;
            if (!createPath && (stat = zookeeper.exists(path, false)) == null) {
                createPath = true;
            }
            if (!createPath) continue;
            ZooKeeperHelper.create(zookeeper, path);
        }
    }

    static void create(ZooKeeper zookeeper, String znode) throws KeeperException, InterruptedException {
        zookeeper.create(znode, new byte[0], (List)ZooDefs.Ids.OPEN_ACL_UNSAFE, CreateMode.PERSISTENT);
    }

    static void create(ZooKeeper zookeeper, String znode, byte[] value) throws KeeperException, InterruptedException {
        zookeeper.create(znode, value, (List)ZooDefs.Ids.OPEN_ACL_UNSAFE, CreateMode.PERSISTENT);
    }

    static void createIfNotThere(ZooKeeper zookeeper, String znode) throws KeeperException, InterruptedException {
        block2: {
            try {
                ZooKeeperHelper.create(zookeeper, znode);
            }
            catch (KeeperException e) {
                if (e.code() == KeeperException.Code.NODEEXISTS) break block2;
                throw e;
            }
        }
    }

    static List<String> pathParts(String path) {
        String[] pathParts = path.split("/");
        ArrayList<String> parts = new ArrayList<String>(pathParts.length);
        String pathSoFar = "";
        for (String pathPart : pathParts) {
            if (pathPart.equals("")) continue;
            pathSoFar = pathSoFar + "/" + pathPart;
            parts.add(pathSoFar);
        }
        return parts;
    }
}

