/*
 * Decompiled with CFR 0.152.
 */
package org.lable.oss.dynamicconfig.zookeeper;

import java.io.IOException;
import java.util.Collections;
import java.util.List;
import java.util.Random;
import java.util.concurrent.CountDownLatch;
import org.apache.zookeeper.CreateMode;
import org.apache.zookeeper.KeeperException;
import org.apache.zookeeper.ZooDefs;
import org.apache.zookeeper.ZooKeeper;
import org.apache.zookeeper.data.Stat;
import org.lable.oss.dynamicconfig.zookeeper.ZooKeeperHelper;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ZookeeperLock {
    private static final Logger logger = LoggerFactory.getLogger(ZookeeperLock.class);
    static String ZNODE;
    static String QUEUE_NODE;
    static final String LOCKING_TICKET = "nr-00000000000000";
    static final Random random;
    final ZooKeeper zookeeper;
    protected State state = State.UNLOCKED;

    ZookeeperLock(ZooKeeper zooKeeper, String znode) {
        ZNODE = znode;
        QUEUE_NODE = znode + "/queue";
        this.zookeeper = zooKeeper;
    }

    void ensureRequiredZnodesExist(ZooKeeper zookeeper, String znode) throws KeeperException, InterruptedException {
    }

    public void lock() throws IOException {
        if (this.state == State.LOCKED) {
            return;
        }
        try {
            ZookeeperLock.acquireLock(this.zookeeper, QUEUE_NODE);
        }
        catch (KeeperException e) {
            throw new IOException(e);
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            throw new IOException(e);
        }
        this.state = State.LOCKED;
    }

    public void unlock() throws IOException {
        if (this.state == State.UNLOCKED) {
            return;
        }
        try {
            ZookeeperLock.releaseTicket(this.zookeeper, QUEUE_NODE, LOCKING_TICKET);
        }
        catch (KeeperException e) {
            throw new IOException(e);
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            throw new IOException(e);
        }
        this.state = State.UNLOCKED;
    }

    static String acquireLock(ZooKeeper zookeeper, String lockNode) throws KeeperException, InterruptedException {
        String placeInLine = ZookeeperLock.takeQueueTicket(zookeeper, lockNode);
        logger.debug("Acquiring lock, waiting in queue: {}.", (Object)placeInLine);
        return ZookeeperLock.waitInLine(zookeeper, lockNode, placeInLine);
    }

    static String takeQueueTicket(ZooKeeper zookeeper, String lockNode) throws InterruptedException, KeeperException {
        String ticket = String.format("nr-%014d-%04d", System.currentTimeMillis(), random.nextInt(10000));
        if (ZookeeperLock.grabTicket(zookeeper, lockNode, ticket)) {
            return ticket;
        }
        return ZookeeperLock.takeQueueTicket(zookeeper, lockNode);
    }

    static void releaseTicket(ZooKeeper zookeeper, String lockNode, String ticket) throws KeeperException, InterruptedException {
        logger.debug("Releasing ticket {}.", (Object)ticket);
        try {
            zookeeper.delete(lockNode + "/" + ticket, -1);
        }
        catch (KeeperException.NoNodeException noNodeException) {
            // empty catch block
        }
    }

    static String waitInLine(ZooKeeper zookeeper, String lockNode, String placeInLine) throws KeeperException, InterruptedException {
        String placeBeforeUs;
        List children;
        try {
            children = zookeeper.getChildren(lockNode, false);
        }
        catch (KeeperException.NoNodeException e) {
            ZooKeeperHelper.mkdirp(zookeeper, lockNode);
            children = zookeeper.getChildren(lockNode, false);
        }
        Collections.sort(children);
        if (children.size() == 0) {
            logger.warn("getChildren() returned empty list, but we created a ticket.");
            return ZookeeperLock.acquireLock(zookeeper, lockNode);
        }
        boolean lockingTicketExists = ((String)children.get(0)).equals(LOCKING_TICKET);
        if (lockingTicketExists) {
            children.remove(0);
        }
        int positionInQueue = -1;
        int i = 0;
        for (String child : children) {
            if (child.equals(placeInLine)) {
                positionInQueue = i;
                break;
            }
            ++i;
        }
        if (positionInQueue < 0) {
            throw new RuntimeException("Created node (" + placeInLine + ") not found in getChildren().");
        }
        if (positionInQueue == 0) {
            if (ZookeeperLock.grabTicket(zookeeper, lockNode, LOCKING_TICKET)) {
                ZookeeperLock.releaseTicket(zookeeper, lockNode, placeInLine);
                return LOCKING_TICKET;
            }
            placeBeforeUs = LOCKING_TICKET;
        } else {
            placeBeforeUs = (String)children.get(positionInQueue - 1);
        }
        CountDownLatch latch = new CountDownLatch(1);
        Stat stat = zookeeper.exists(lockNode + "/" + placeBeforeUs, event -> latch.countDown());
        if (stat != null) {
            logger.debug("Watching place in queue before us ({})", (Object)placeBeforeUs);
            latch.await();
        }
        return ZookeeperLock.waitInLine(zookeeper, lockNode, placeInLine);
    }

    static boolean grabTicket(ZooKeeper zookeeper, String lockNode, String ticket) throws InterruptedException, KeeperException {
        try {
            zookeeper.create(lockNode + "/" + ticket, new byte[0], (List)ZooDefs.Ids.OPEN_ACL_UNSAFE, CreateMode.EPHEMERAL);
        }
        catch (KeeperException.NodeExistsException e) {
            logger.debug("Failed to claim ticket {}.", (Object)ticket);
            return false;
        }
        catch (KeeperException.NoNodeException e) {
            ZooKeeperHelper.mkdirp(zookeeper, lockNode);
        }
        logger.debug("Claimed ticket {}.", (Object)ticket);
        return true;
    }

    static {
        random = new Random();
    }

    public static enum State {
        LOCKED,
        UNLOCKED;

    }
}

