/*
 * Decompiled with CFR 0.152.
 */
package org.lable.oss.dynamicconfig.zookeeper;

import java.time.Duration;
import java.time.Instant;
import java.time.temporal.ChronoUnit;
import java.util.Collections;
import java.util.List;
import java.util.Random;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import java.util.concurrent.locks.Condition;
import java.util.concurrent.locks.Lock;
import java.util.function.Supplier;
import org.apache.zookeeper.CreateMode;
import org.apache.zookeeper.KeeperException;
import org.apache.zookeeper.ZooDefs;
import org.apache.zookeeper.ZooKeeper;
import org.apache.zookeeper.data.Stat;
import org.lable.oss.dynamicconfig.zookeeper.ZooKeeperHelper;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import sun.reflect.generics.reflectiveObjects.NotImplementedException;

public class ZooKeeperLock
implements Lock {
    private static final Logger logger = LoggerFactory.getLogger(ZooKeeperLock.class);
    static String ZNODE;
    static String QUEUE_NODE;
    static final String LOCKING_TICKET = "nr-00000000000000";
    static final Random random;
    final Supplier<ZooKeeper> zooKeeperSupplier;
    protected State state = State.UNLOCKED;

    ZooKeeperLock(Supplier<ZooKeeper> zooKeeperSupplier, String znode) {
        ZNODE = znode;
        QUEUE_NODE = znode + "/queue";
        this.zooKeeperSupplier = zooKeeperSupplier;
    }

    @Override
    public void lock() {
        try {
            this.lockInterruptibly();
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
        }
    }

    @Override
    public void lockInterruptibly() throws InterruptedException {
        if (this.state == State.LOCKED) {
            return;
        }
        try {
            ZooKeeperLock.acquireLock(this.zooKeeperSupplier.get(), QUEUE_NODE);
        }
        catch (KeeperException e) {
            logger.warn("Failed to acquire ZooKeeper lock due to {}. Sleeping 5s before retrying.", (Object)((Object)((Object)e)).getClass().getName());
            TimeUnit.SECONDS.sleep(5L);
            this.lockInterruptibly();
        }
        this.state = State.LOCKED;
    }

    @Override
    public boolean tryLock() {
        if (this.state == State.LOCKED) {
            return true;
        }
        try {
            ZooKeeperLock.acquireLock(this.zooKeeperSupplier.get(), QUEUE_NODE, null, true);
        }
        catch (KeeperException e) {
            logger.warn("Failed to acquire ZooKeeper lock due to {}.", (Object)((Object)((Object)e)).getClass().getName());
            return false;
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            return false;
        }
        catch (TimeoutException e) {
            return false;
        }
        this.state = State.LOCKED;
        return true;
    }

    @Override
    public boolean tryLock(long time, TimeUnit unit) throws InterruptedException {
        if (this.state == State.LOCKED) {
            return true;
        }
        try {
            ZooKeeperLock.acquireLock(this.zooKeeperSupplier.get(), QUEUE_NODE, Instant.now().plus(unit.toMillis(time), ChronoUnit.MILLIS), false);
        }
        catch (KeeperException e) {
            logger.warn("Failed to acquire ZooKeeper lock due to {}.", (Object)((Object)((Object)e)).getClass().getName());
            return false;
        }
        catch (TimeoutException e) {
            return false;
        }
        this.state = State.LOCKED;
        return true;
    }

    @Override
    public void unlock() {
        if (this.state == State.UNLOCKED) {
            return;
        }
        try {
            ZooKeeperLock.releaseTicket(this.zooKeeperSupplier.get(), QUEUE_NODE, LOCKING_TICKET);
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
        }
        this.state = State.UNLOCKED;
    }

    @Override
    public Condition newCondition() {
        throw new NotImplementedException();
    }

    static String acquireLock(ZooKeeper zookeeper, String lockNode) throws KeeperException, InterruptedException {
        try {
            return ZooKeeperLock.acquireLock(zookeeper, lockNode, null, false);
        }
        catch (TimeoutException e) {
            throw new RuntimeException("Impossible exception (you found a bug).", e);
        }
    }

    static String acquireLock(ZooKeeper zookeeper, String lockNode, Instant timeLimit, boolean returnIfNotFree) throws KeeperException, InterruptedException, TimeoutException {
        String placeInLine = ZooKeeperLock.takeQueueTicket(zookeeper, lockNode);
        logger.debug("Acquiring lock, waiting in queue: {}.", (Object)placeInLine);
        return ZooKeeperLock.waitInLine(zookeeper, lockNode, placeInLine, timeLimit, returnIfNotFree);
    }

    static String takeQueueTicket(ZooKeeper zookeeper, String lockNode) throws InterruptedException, KeeperException {
        String ticket = String.format("nr-%014d-%04d", System.currentTimeMillis(), random.nextInt(10000));
        if (ZooKeeperLock.grabTicket(zookeeper, lockNode, ticket)) {
            return ticket;
        }
        return ZooKeeperLock.takeQueueTicket(zookeeper, lockNode);
    }

    static void releaseTicket(ZooKeeper zookeeper, String lockNode, String ticket) throws InterruptedException {
        logger.debug("Releasing ticket {}.", (Object)ticket);
        try {
            zookeeper.delete(lockNode + "/" + ticket, -1);
        }
        catch (KeeperException.NoNodeException noNodeException) {
        }
        catch (KeeperException e) {
            logger.error("Unexpected exception: {}.", (Object)((Object)((Object)e)).getClass().getName());
        }
    }

    static String waitInLine(ZooKeeper zookeeper, String lockNode, String placeInLine, Instant timeLimit, boolean returnIfNotFree) throws KeeperException, InterruptedException, TimeoutException {
        String placeBeforeUs;
        List children;
        try {
            children = zookeeper.getChildren(lockNode, false);
        }
        catch (KeeperException.NoNodeException e) {
            ZooKeeperHelper.mkdirp(zookeeper, lockNode);
            children = zookeeper.getChildren(lockNode, false);
        }
        Collections.sort(children);
        if (children.size() == 0) {
            logger.warn("getChildren() returned empty list, but we created a ticket.");
            return ZooKeeperLock.acquireLock(zookeeper, lockNode);
        }
        boolean lockingTicketExists = ((String)children.get(0)).equals(LOCKING_TICKET);
        if (lockingTicketExists) {
            children.remove(0);
        }
        int positionInQueue = -1;
        int i = 0;
        for (String child : children) {
            if (child.equals(placeInLine)) {
                positionInQueue = i;
                break;
            }
            ++i;
        }
        if (positionInQueue < 0) {
            throw new RuntimeException("Created node (" + placeInLine + ") not found in getChildren().");
        }
        if (positionInQueue == 0) {
            if (ZooKeeperLock.grabTicket(zookeeper, lockNode, LOCKING_TICKET)) {
                ZooKeeperLock.releaseTicket(zookeeper, lockNode, placeInLine);
                return LOCKING_TICKET;
            }
            placeBeforeUs = LOCKING_TICKET;
        } else {
            placeBeforeUs = (String)children.get(positionInQueue - 1);
        }
        if (returnIfNotFree) {
            throw new TimeoutException("Someone else holds the lock. Aborting as requested.");
        }
        CountDownLatch latch = new CountDownLatch(1);
        Stat stat = zookeeper.exists(lockNode + "/" + placeBeforeUs, event -> latch.countDown());
        if (stat != null) {
            logger.debug("Watching place in queue before us ({})", (Object)placeBeforeUs);
            if (timeLimit == null) {
                latch.await();
            } else {
                boolean timedOut;
                long waitFor = Duration.between(Instant.now(), timeLimit).toMillis();
                if (waitFor <= 0L) {
                    throw new TimeoutException("Acquiring the lock is taking too long.");
                }
                boolean bl = timedOut = !latch.await(waitFor, TimeUnit.MILLISECONDS);
                if (timedOut) {
                    ZooKeeperLock.releaseTicket(zookeeper, lockNode, placeInLine);
                    throw new TimeoutException("Acquiring the lock is taking too long.");
                }
            }
        }
        return ZooKeeperLock.waitInLine(zookeeper, lockNode, placeInLine, timeLimit, false);
    }

    static boolean grabTicket(ZooKeeper zookeeper, String lockNode, String ticket) throws InterruptedException, KeeperException {
        try {
            zookeeper.create(lockNode + "/" + ticket, new byte[0], (List)ZooDefs.Ids.OPEN_ACL_UNSAFE, CreateMode.EPHEMERAL);
        }
        catch (KeeperException.NodeExistsException e) {
            logger.debug("Failed to claim ticket {}.", (Object)ticket);
            return false;
        }
        catch (KeeperException.NoNodeException e) {
            ZooKeeperHelper.mkdirp(zookeeper, lockNode);
        }
        logger.debug("Claimed ticket {}.", (Object)ticket);
        return true;
    }

    static {
        random = new Random();
    }

    public static enum State {
        LOCKED,
        UNLOCKED;

    }
}

