/*
 * Decompiled with CFR 0.152.
 */
package org.lable.oss.uniqueid.etcd;

import io.etcd.jetcd.ByteSequence;
import io.etcd.jetcd.Client;
import io.etcd.jetcd.CloseableClient;
import io.etcd.jetcd.KeyValue;
import io.etcd.jetcd.kv.GetResponse;
import io.etcd.jetcd.lease.LeaseKeepAliveResponse;
import io.grpc.stub.StreamObserver;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.Optional;
import java.util.concurrent.ExecutionException;

public class EtcdHelper {
    static final ByteSequence UNIQUE_ID_NAMESPACE = ByteSequence.from((String)"unique-id/", (Charset)StandardCharsets.UTF_8);

    public static Optional<Integer> getInt(Client etcd, String key) throws ExecutionException, InterruptedException {
        GetResponse getResponse = (GetResponse)etcd.getKVClient().get(EtcdHelper.asByteSequence(key)).get();
        if (getResponse.getCount() == 0L) {
            return Optional.empty();
        }
        String value = ((KeyValue)getResponse.getKvs().get(0)).getValue().toString(StandardCharsets.UTF_8);
        try {
            return Optional.of(Integer.parseInt(value));
        }
        catch (NumberFormatException e) {
            return Optional.empty();
        }
    }

    public static Optional<String> get(Client etcd, String key) throws ExecutionException, InterruptedException {
        GetResponse getResponse = (GetResponse)etcd.getKVClient().get(EtcdHelper.asByteSequence(key)).get();
        if (getResponse.getCount() == 0L) {
            return Optional.empty();
        }
        return Optional.of(((KeyValue)getResponse.getKvs().get(0)).getValue().toString(StandardCharsets.UTF_8));
    }

    public static void put(Client etcd, String key, int value) throws ExecutionException, InterruptedException {
        etcd.getKVClient().put(EtcdHelper.asByteSequence(key), EtcdHelper.asByteSequence(value)).get();
    }

    public static void put(Client etcd, String key) throws ExecutionException, InterruptedException {
        etcd.getKVClient().put(EtcdHelper.asByteSequence(key), ByteSequence.EMPTY).get();
    }

    public static void delete(Client etcd, String key) throws ExecutionException, InterruptedException {
        etcd.getKVClient().delete(EtcdHelper.asByteSequence(key)).get();
    }

    static ByteSequence asByteSequence(String value) {
        return ByteSequence.from((String)value, (Charset)StandardCharsets.UTF_8);
    }

    static ByteSequence asByteSequence(int value) {
        return EtcdHelper.asByteSequence(String.valueOf(value));
    }

    public static CloseableClient keepLeaseAlive(Client etcd, Long leaseId, OnRelease onRelease) {
        final OnRelease onReleaseCallback = onRelease == null ? () -> {} : onRelease;
        return etcd.getLeaseClient().keepAlive(leaseId.longValue(), (StreamObserver)new StreamObserver<LeaseKeepAliveResponse>(){

            public void onNext(LeaseKeepAliveResponse value) {
            }

            public void onError(Throwable t) {
                onReleaseCallback.cleanUp();
            }

            public void onCompleted() {
                onReleaseCallback.cleanUp();
            }
        });
    }

    @FunctionalInterface
    static interface OnRelease {
        public void cleanUp();
    }
}

