/*
 * Decompiled with CFR 0.152.
 */
package com.shaded.google.common.graph;

import com.shaded.google.common.annotations.Beta;
import com.shaded.google.common.base.Function;
import com.shaded.google.common.base.Functions;
import com.shaded.google.common.base.Preconditions;
import com.shaded.google.common.collect.ImmutableMap;
import com.shaded.google.common.collect.Maps;
import com.shaded.google.common.graph.BaseGraph;
import com.shaded.google.common.graph.ConfigurableValueGraph;
import com.shaded.google.common.graph.DirectedGraphConnections;
import com.shaded.google.common.graph.ForwardingGraph;
import com.shaded.google.common.graph.Graph;
import com.shaded.google.common.graph.GraphBuilder;
import com.shaded.google.common.graph.GraphConnections;
import com.shaded.google.common.graph.GraphConstants;
import com.shaded.google.common.graph.UndirectedGraphConnections;
import com.shaded.google.errorprone.annotations.Immutable;

@Immutable(containerOf={"N"})
@Beta
public class ImmutableGraph<N>
extends ForwardingGraph<N> {
    private final BaseGraph<N> backingGraph;

    ImmutableGraph(BaseGraph<N> backingGraph) {
        this.backingGraph = backingGraph;
    }

    public static <N> ImmutableGraph<N> copyOf(Graph<N> graph) {
        return graph instanceof ImmutableGraph ? (ImmutableGraph<N>)graph : new ImmutableGraph<N>(new ConfigurableValueGraph<N, GraphConstants.Presence>(GraphBuilder.from(graph), ImmutableGraph.getNodeConnections(graph), graph.edges().size()));
    }

    @Deprecated
    public static <N> ImmutableGraph<N> copyOf(ImmutableGraph<N> graph) {
        return Preconditions.checkNotNull(graph);
    }

    private static <N> ImmutableMap<N, GraphConnections<N, GraphConstants.Presence>> getNodeConnections(Graph<N> graph) {
        ImmutableMap.Builder<N, GraphConnections<N, GraphConstants.Presence>> nodeConnections = ImmutableMap.builder();
        for (N node : graph.nodes()) {
            nodeConnections.put(node, ImmutableGraph.connectionsOf(graph, node));
        }
        return nodeConnections.build();
    }

    private static <N> GraphConnections<N, GraphConstants.Presence> connectionsOf(Graph<N> graph, N node) {
        Function<Object, GraphConstants.Presence> edgeValueFn = Functions.constant(GraphConstants.Presence.EDGE_EXISTS);
        return graph.isDirected() ? DirectedGraphConnections.ofImmutable(graph.predecessors(node), Maps.asMap(graph.successors(node), edgeValueFn)) : UndirectedGraphConnections.ofImmutable(Maps.asMap(graph.adjacentNodes(node), edgeValueFn));
    }

    @Override
    protected BaseGraph<N> delegate() {
        return this.backingGraph;
    }
}

