/*
 * Decompiled with CFR 0.152.
 */
package org.lable.oss.uniqueid;

import java.io.IOException;
import org.lable.oss.uniqueid.GeneratorIdentityHolder;
import org.lable.oss.uniqueid.ParameterUtil;

public class LocalGeneratorIdentity
implements GeneratorIdentityHolder {
    private final int clusterId;
    private final int generatorId;
    private boolean closed = false;

    LocalGeneratorIdentity(int clusterId, int generatorId) {
        this.clusterId = clusterId;
        this.generatorId = generatorId;
    }

    public static LocalGeneratorIdentity with(int clusterId, int generatorId) {
        ParameterUtil.assertParameterWithinBounds("generatorId", 0L, 255L, generatorId);
        ParameterUtil.assertParameterWithinBounds("clusterId", 0L, 15L, clusterId);
        return new LocalGeneratorIdentity(clusterId, generatorId);
    }

    @Override
    public int getClusterId() {
        if (this.closed) {
            throw new IllegalStateException("Resource was closed.");
        }
        return this.clusterId;
    }

    @Override
    public int getGeneratorId() {
        if (this.closed) {
            throw new IllegalStateException("Resource was closed.");
        }
        return this.generatorId;
    }

    @Override
    public void close() throws IOException {
        this.closed = true;
    }
}

