/*
 * Decompiled with CFR 0.152.
 */
package io.etcd.jetcd;

import com.shaded.google.common.base.Preconditions;
import io.etcd.jetcd.ByteSequence;
import io.etcd.jetcd.Client;
import io.etcd.jetcd.ClientImpl;
import io.etcd.jetcd.Util;
import io.etcd.jetcd.common.exception.EtcdExceptionFactory;
import io.etcd.jetcd.resolver.URIResolverLoader;
import io.shaded.grpc.ClientInterceptor;
import io.shaded.grpc.Metadata;
import io.shaded.netty.handler.ssl.SslContext;
import java.net.URI;
import java.time.temporal.ChronoUnit;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ExecutorService;

public final class ClientBuilder
implements Cloneable {
    private final Set<URI> endpoints = new HashSet<URI>();
    private ByteSequence user;
    private ByteSequence password;
    private ExecutorService executorService;
    private String loadBalancerPolicy;
    private SslContext sslContext;
    private boolean lazyInitialization = false;
    private String authority;
    private URIResolverLoader uriResolverLoader;
    private Integer maxInboundMessageSize;
    private Map<Metadata.Key, Object> headers;
    private List<ClientInterceptor> interceptors;
    private ByteSequence namespace = ByteSequence.EMPTY;
    private long retryDelay = 500L;
    private long retryMaxDelay = 2500L;
    private ChronoUnit retryChronoUnit = ChronoUnit.MILLIS;
    private String retryMaxDuration;

    ClientBuilder() {
    }

    public Collection<URI> endpoints() {
        return Collections.unmodifiableCollection(this.endpoints);
    }

    public ClientBuilder endpoints(Collection<URI> endpoints) {
        Preconditions.checkNotNull(endpoints, "endpoints can't be null");
        for (URI endpoint : endpoints) {
            Preconditions.checkNotNull(endpoint, "endpoint can't be null");
            Preconditions.checkArgument(endpoint.toString().trim().length() > 0, "invalid endpoint: endpoint=" + endpoint);
            this.endpoints.add(endpoint);
        }
        return this;
    }

    public ClientBuilder endpoints(URI ... endpoints) {
        Preconditions.checkNotNull(endpoints, "endpoints can't be null");
        return this.endpoints(Arrays.asList(endpoints));
    }

    public ClientBuilder endpoints(String ... endpoints) {
        return this.endpoints(Util.toURIs(Arrays.asList(endpoints)));
    }

    public ByteSequence user() {
        return this.user;
    }

    public ClientBuilder user(ByteSequence user) {
        Preconditions.checkNotNull(user, "user can't be null");
        this.user = user;
        return this;
    }

    public ByteSequence password() {
        return this.password;
    }

    public ClientBuilder password(ByteSequence password) {
        Preconditions.checkNotNull(password, "password can't be null");
        this.password = password;
        return this;
    }

    public ByteSequence namespace() {
        return this.namespace;
    }

    public ClientBuilder namespace(ByteSequence namespace) {
        Preconditions.checkNotNull(namespace, "namespace can't be null");
        this.namespace = namespace;
        return this;
    }

    public ExecutorService executorService() {
        return this.executorService;
    }

    public ClientBuilder executorService(ExecutorService executorService) {
        Preconditions.checkNotNull(executorService, "executorService can't be null");
        this.executorService = executorService;
        return this;
    }

    public ClientBuilder loadBalancerPolicy(String loadBalancerPolicy) {
        Preconditions.checkNotNull(loadBalancerPolicy, "loadBalancerPolicy can't be null");
        this.loadBalancerPolicy = loadBalancerPolicy;
        return this;
    }

    public String loadBalancerPolicy() {
        return this.loadBalancerPolicy;
    }

    public boolean lazyInitialization() {
        return this.lazyInitialization;
    }

    public ClientBuilder lazyInitialization(boolean lazyInitialization) {
        this.lazyInitialization = lazyInitialization;
        return this;
    }

    public SslContext sslContext() {
        return this.sslContext;
    }

    public ClientBuilder sslContext(SslContext sslContext) {
        this.sslContext = sslContext;
        return this;
    }

    public String authority() {
        return this.authority;
    }

    public ClientBuilder authority(String authority) {
        this.authority = authority;
        return this;
    }

    public URIResolverLoader uriResolverLoader() {
        return this.uriResolverLoader;
    }

    public ClientBuilder uriResolverLoader(URIResolverLoader loader) {
        this.uriResolverLoader = loader;
        return this;
    }

    public Integer maxInboundMessageSize() {
        return this.maxInboundMessageSize;
    }

    public ClientBuilder maxInboundMessageSize(Integer maxInboundMessageSize) {
        this.maxInboundMessageSize = maxInboundMessageSize;
        return this;
    }

    public Map<Metadata.Key, Object> headers() {
        return this.headers;
    }

    public ClientBuilder headers(Map<Metadata.Key, Object> headers) {
        this.headers = new HashMap<Metadata.Key, Object>(headers);
        return this;
    }

    public ClientBuilder header(String key, String value) {
        if (this.headers == null) {
            this.headers = new HashMap<Metadata.Key, Object>();
        }
        this.headers.put(Metadata.Key.of(key, Metadata.ASCII_STRING_MARSHALLER), value);
        return this;
    }

    public List<ClientInterceptor> interceptors() {
        return this.interceptors;
    }

    public ClientBuilder interceptors(List<ClientInterceptor> interceptors) {
        this.interceptors = new ArrayList<ClientInterceptor>(interceptors);
        return this;
    }

    public ClientBuilder interceptor(ClientInterceptor interceptor, ClientInterceptor ... interceptors) {
        if (this.interceptors == null) {
            this.interceptors = new ArrayList<ClientInterceptor>();
        }
        this.interceptors.add(interceptor);
        for (ClientInterceptor i : interceptors) {
            this.interceptors.add(i);
        }
        return this;
    }

    public long retryDelay() {
        return this.retryDelay;
    }

    public ClientBuilder retryDelay(long retryDelay) {
        this.retryDelay = retryDelay;
        return this;
    }

    public long retryMaxDelay() {
        return this.retryMaxDelay;
    }

    public ClientBuilder retryMaxDelay(long retryMaxDelay) {
        this.retryMaxDelay = retryMaxDelay;
        return this;
    }

    public ChronoUnit retryChronoUnit() {
        return this.retryChronoUnit;
    }

    public ClientBuilder retryChronoUnit(ChronoUnit retryChronoUnit) {
        this.retryChronoUnit = retryChronoUnit;
        return this;
    }

    public String retryMaxDuration() {
        return this.retryMaxDuration;
    }

    public ClientBuilder retryMaxDuration(String retryMaxDuration) {
        this.retryMaxDuration = retryMaxDuration;
        return this;
    }

    public Client build() {
        Preconditions.checkState(!this.endpoints.isEmpty(), "please configure etcd server endpoints before build.");
        return new ClientImpl(this);
    }

    public ClientBuilder copy() {
        try {
            return (ClientBuilder)super.clone();
        }
        catch (CloneNotSupportedException e) {
            throw EtcdExceptionFactory.toEtcdException(e);
        }
    }
}

