/*
 * Decompiled with CFR 0.152.
 */
package io.shaded.grpc.internal;

import com.shaded.google.common.base.MoreObjects;
import com.shaded.google.common.base.Preconditions;
import io.shaded.grpc.Attributes;
import io.shaded.grpc.CallCredentials;
import io.shaded.grpc.CallOptions;
import io.shaded.grpc.ChannelLogger;
import io.shaded.grpc.Metadata;
import io.shaded.grpc.MethodDescriptor;
import io.shaded.grpc.SecurityLevel;
import io.shaded.grpc.Status;
import io.shaded.grpc.internal.ClientStream;
import io.shaded.grpc.internal.ClientTransportFactory;
import io.shaded.grpc.internal.ConnectionClientTransport;
import io.shaded.grpc.internal.ForwardingConnectionClientTransport;
import io.shaded.grpc.internal.GrpcAttributes;
import io.shaded.grpc.internal.MetadataApplierImpl;
import java.net.SocketAddress;
import java.util.concurrent.Executor;
import java.util.concurrent.ScheduledExecutorService;

final class CallCredentialsApplyingTransportFactory
implements ClientTransportFactory {
    private final ClientTransportFactory delegate;
    private final Executor appExecutor;

    CallCredentialsApplyingTransportFactory(ClientTransportFactory delegate, Executor appExecutor) {
        this.delegate = Preconditions.checkNotNull(delegate, "delegate");
        this.appExecutor = Preconditions.checkNotNull(appExecutor, "appExecutor");
    }

    @Override
    public ConnectionClientTransport newClientTransport(SocketAddress serverAddress, ClientTransportFactory.ClientTransportOptions options, ChannelLogger channelLogger) {
        return new CallCredentialsApplyingTransport(this.delegate.newClientTransport(serverAddress, options, channelLogger), options.getAuthority());
    }

    @Override
    public ScheduledExecutorService getScheduledExecutorService() {
        return this.delegate.getScheduledExecutorService();
    }

    @Override
    public void close() {
        this.delegate.close();
    }

    private class CallCredentialsApplyingTransport
    extends ForwardingConnectionClientTransport {
        private final ConnectionClientTransport delegate;
        private final String authority;

        CallCredentialsApplyingTransport(ConnectionClientTransport delegate, String authority) {
            this.delegate = Preconditions.checkNotNull(delegate, "delegate");
            this.authority = Preconditions.checkNotNull(authority, "authority");
        }

        @Override
        protected ConnectionClientTransport delegate() {
            return this.delegate;
        }

        @Override
        public ClientStream newStream(final MethodDescriptor<?, ?> method, Metadata headers, final CallOptions callOptions) {
            CallCredentials creds = callOptions.getCredentials();
            if (creds != null) {
                MetadataApplierImpl applier = new MetadataApplierImpl(this.delegate, method, headers, callOptions);
                CallCredentials.RequestInfo requestInfo = new CallCredentials.RequestInfo(){

                    @Override
                    public MethodDescriptor<?, ?> getMethodDescriptor() {
                        return method;
                    }

                    @Override
                    public SecurityLevel getSecurityLevel() {
                        return MoreObjects.firstNonNull(CallCredentialsApplyingTransport.this.delegate.getAttributes().get(GrpcAttributes.ATTR_SECURITY_LEVEL), SecurityLevel.NONE);
                    }

                    @Override
                    public String getAuthority() {
                        return MoreObjects.firstNonNull(callOptions.getAuthority(), CallCredentialsApplyingTransport.this.authority);
                    }

                    @Override
                    public Attributes getTransportAttrs() {
                        return CallCredentialsApplyingTransport.this.delegate.getAttributes();
                    }
                };
                try {
                    creds.applyRequestMetadata(requestInfo, MoreObjects.firstNonNull(callOptions.getExecutor(), CallCredentialsApplyingTransportFactory.this.appExecutor), applier);
                }
                catch (Throwable t) {
                    applier.fail(Status.UNAUTHENTICATED.withDescription("Credentials should use fail() instead of throwing exceptions").withCause(t));
                }
                return applier.returnStream();
            }
            return this.delegate.newStream(method, headers, callOptions);
        }
    }
}

