/*
 * Decompiled with CFR 0.152.
 */
package org.lable.oss.uniqueid;

import java.io.IOException;
import java.util.ArrayDeque;
import java.util.Deque;
import java.util.concurrent.TimeUnit;
import org.lable.oss.uniqueid.GeneratorException;
import org.lable.oss.uniqueid.IDGenerator;

public class OnePerMillisecondDecorator
implements IDGenerator {
    final IDGenerator generator;
    long previousInvocation = 0L;
    byte[] previous = null;

    protected OnePerMillisecondDecorator(IDGenerator generator) {
        this.generator = generator;
    }

    public static IDGenerator decorate(IDGenerator generator) {
        return new OnePerMillisecondDecorator(generator);
    }

    @Override
    public void close() throws IOException {
        this.generator.close();
    }

    @Override
    public byte[] generate() throws GeneratorException {
        long now = System.currentTimeMillis();
        while (this.previousInvocation == now) {
            this.sleepAMillisecond();
            now = System.currentTimeMillis();
        }
        this.previousInvocation = now;
        byte[] id = this.generator.generate();
        if (this.previous != null) {
            while (this.previous[0] == id[0]) {
                this.sleepAMillisecond();
                id = this.generator.generate();
            }
        }
        this.previous = id;
        return id;
    }

    private void sleepAMillisecond() {
        try {
            TimeUnit.MILLISECONDS.sleep(1L);
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
        }
    }

    @Override
    public Deque<byte[]> batch(int size) throws GeneratorException {
        ArrayDeque<byte[]> deck = new ArrayDeque<byte[]>();
        for (int i = 0; i < size; ++i) {
            deck.add(this.generate());
        }
        return deck;
    }
}

