/*
 * Decompiled with CFR 0.152.
 */
package org.lable.oss.uniqueid.etcd;

import io.etcd.jetcd.ByteSequence;
import io.etcd.jetcd.Client;
import io.etcd.jetcd.KeyValue;
import io.etcd.jetcd.kv.GetResponse;
import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.ExecutionException;
import java.util.stream.Collectors;
import java.util.stream.Stream;

public class ClusterID {
    static final ByteSequence CLUSTER_ID_KEY = ByteSequence.from("cluster-id", StandardCharsets.UTF_8);
    static final int DEFAULT_CLUSTER_ID = 0;

    public static List<Integer> get(Client etcd) throws IOException {
        GetResponse get;
        try {
            get = etcd.getKVClient().get(CLUSTER_ID_KEY).get();
        }
        catch (InterruptedException | ExecutionException e) {
            throw new IOException(e);
        }
        List<Integer> ids = null;
        for (KeyValue kv : get.getKvs()) {
            if (!kv.getKey().equals(CLUSTER_ID_KEY)) continue;
            String value = kv.getValue().toString(StandardCharsets.UTF_8);
            try {
                ids = ClusterID.parseIntegers(value);
                break;
            }
            catch (NumberFormatException e) {
                throw new IOException("Failed to parse cluster-id value `" + value + "`.", e);
            }
        }
        if (ids == null) {
            ByteSequence defaultValue = ByteSequence.from(String.valueOf(0).getBytes());
            try {
                etcd.getKVClient().put(CLUSTER_ID_KEY, defaultValue).get();
                return Collections.singletonList(0);
            }
            catch (InterruptedException | ExecutionException e) {
                throw new IOException(e);
            }
        }
        return ids;
    }

    static List<Integer> parseIntegers(String serialized) {
        return Stream.of(serialized.split(",")).map(String::trim).map(Integer::parseInt).collect(Collectors.toList());
    }
}

