/*
 * Decompiled with CFR 0.152.
 */
package org.lable.oss.uniqueid.etcd;

import io.etcd.jetcd.Client;
import java.io.IOException;
import java.time.Duration;
import java.util.List;
import java.util.Timer;
import java.util.TimerTask;
import org.lable.oss.uniqueid.etcd.ResourceClaim;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ExpiringResourceClaim
extends ResourceClaim {
    private static final Logger logger = LoggerFactory.getLogger(ExpiringResourceClaim.class);
    public static final Duration DEFAULT_CLAIM_HOLD = Duration.ofSeconds(30L);
    public static final Duration DEFAULT_ACQUISITION_TIMEOUT = Duration.ofMinutes(10L);

    ExpiringResourceClaim(Client etcd, int maxGeneratorCount, List<Integer> clusterIds, Duration claimHold, Duration acquisitionTimeout) throws IOException {
        super(etcd, maxGeneratorCount, clusterIds, acquisitionTimeout);
        new Timer().schedule(new TimerTask(){

            @Override
            public void run() {
                ExpiringResourceClaim.this.close();
            }
        }, claimHold.toMillis());
    }

    public static ResourceClaim claimExpiring(Client etcd, int maxGeneratorCount, List<Integer> clusterIds) throws IOException {
        return ExpiringResourceClaim.claimExpiring(etcd, maxGeneratorCount, clusterIds, DEFAULT_CLAIM_HOLD, DEFAULT_ACQUISITION_TIMEOUT);
    }

    public static ResourceClaim claimExpiring(Client etcd, int maxGeneratorCount, List<Integer> clusterIds, Duration claimHold, Duration acquisitionTimeout) throws IOException {
        Duration duration = claimHold = claimHold == null ? DEFAULT_CLAIM_HOLD : claimHold;
        if (logger.isDebugEnabled()) {
            logger.debug("Preparing expiring resource-claim; will release it in {}ms.", (Object)claimHold.toMillis());
        }
        return new ExpiringResourceClaim(etcd, maxGeneratorCount, clusterIds, claimHold, acquisitionTimeout);
    }
}

