/*
 * Decompiled with CFR 0.152.
 */
package org.lable.oss.uniqueid.etcd;

import io.etcd.jetcd.ByteSequence;
import io.etcd.jetcd.Client;
import java.io.IOException;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import org.lable.oss.uniqueid.GeneratorException;
import org.lable.oss.uniqueid.GeneratorIdentityHolder;
import org.lable.oss.uniqueid.etcd.RegistryBasedResourceClaim;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RegistryBasedGeneratorIdentity
implements GeneratorIdentityHolder {
    private static final Logger logger = LoggerFactory.getLogger(RegistryBasedGeneratorIdentity.class);
    private final String endpoints;
    private final String namespace;
    private final RegistryBasedResourceClaim resourceClaim;

    public RegistryBasedGeneratorIdentity(String endpoints, String namespace, String registryEntry) {
        this.endpoints = endpoints;
        this.namespace = namespace;
        try {
            this.resourceClaim = this.acquireResourceClaim(registryEntry, 0);
        }
        catch (GeneratorException e) {
            throw new RuntimeException(e);
        }
    }

    public static RegistryBasedGeneratorIdentity basedOn(String endpoints, String namespace, String registryEntry) throws IOException {
        return new RegistryBasedGeneratorIdentity(endpoints, namespace, registryEntry);
    }

    public int getClusterId() throws GeneratorException {
        return this.resourceClaim.getClusterId();
    }

    public int getGeneratorId() throws GeneratorException {
        return this.resourceClaim.getGeneratorId();
    }

    public String getRegistryEntry() {
        return this.resourceClaim.getRegistryEntry();
    }

    private RegistryBasedResourceClaim acquireResourceClaim(String registryEntry, int retries) throws GeneratorException {
        try {
            return RegistryBasedResourceClaim.claim(this::getEtcdConnection, 2048, registryEntry);
        }
        catch (IOException e) {
            logger.warn("Connection to Etcd failed, retrying resource claim acquisition, attempt {}.", (Object)(retries + 1));
            if (retries < 3) {
                return this.acquireResourceClaim(registryEntry, retries + 1);
            }
            throw new GeneratorException((Throwable)e);
        }
    }

    Client getEtcdConnection() {
        return Client.builder().endpoints(this.endpoints.split(",")).namespace(ByteSequence.from((String)this.namespace, (Charset)StandardCharsets.UTF_8)).build();
    }

    public void close() throws IOException {
        if (this.resourceClaim != null) {
            this.resourceClaim.close();
        }
    }
}

