/*
 * Decompiled with CFR 0.152.
 */
package io.shaded.grpc.internal;

import com.shaded.google.common.annotations.VisibleForTesting;
import com.shaded.google.common.base.Preconditions;
import com.shaded.google.common.util.concurrent.MoreExecutors;
import io.opencensus.trace.Tracing;
import io.shaded.grpc.BinaryLog;
import io.shaded.grpc.BindableService;
import io.shaded.grpc.CompressorRegistry;
import io.shaded.grpc.Context;
import io.shaded.grpc.Deadline;
import io.shaded.grpc.DecompressorRegistry;
import io.shaded.grpc.HandlerRegistry;
import io.shaded.grpc.InternalChannelz;
import io.shaded.grpc.InternalNotifyOnServerBuild;
import io.shaded.grpc.Server;
import io.shaded.grpc.ServerBuilder;
import io.shaded.grpc.ServerInterceptor;
import io.shaded.grpc.ServerMethodDefinition;
import io.shaded.grpc.ServerServiceDefinition;
import io.shaded.grpc.ServerStreamTracer;
import io.shaded.grpc.ServerTransportFilter;
import io.shaded.grpc.internal.CallTracer;
import io.shaded.grpc.internal.CensusStatsModule;
import io.shaded.grpc.internal.CensusTracingModule;
import io.shaded.grpc.internal.FixedObjectPool;
import io.shaded.grpc.internal.GrpcUtil;
import io.shaded.grpc.internal.InternalHandlerRegistry;
import io.shaded.grpc.internal.InternalServer;
import io.shaded.grpc.internal.ObjectPool;
import io.shaded.grpc.internal.ServerImpl;
import io.shaded.grpc.internal.SharedResourcePool;
import io.shaded.grpc.internal.TransportTracer;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.Executor;
import java.util.concurrent.TimeUnit;
import javax.annotation.Nullable;

public abstract class AbstractServerImplBuilder<T extends AbstractServerImplBuilder<T>>
extends ServerBuilder<T> {
    private static final ObjectPool<? extends Executor> DEFAULT_EXECUTOR_POOL = SharedResourcePool.forResource(GrpcUtil.SHARED_CHANNEL_EXECUTOR);
    private static final HandlerRegistry DEFAULT_FALLBACK_REGISTRY = new DefaultFallbackRegistry();
    private static final DecompressorRegistry DEFAULT_DECOMPRESSOR_REGISTRY = DecompressorRegistry.getDefaultInstance();
    private static final CompressorRegistry DEFAULT_COMPRESSOR_REGISTRY = CompressorRegistry.getDefaultInstance();
    private static final long DEFAULT_HANDSHAKE_TIMEOUT_MILLIS = TimeUnit.SECONDS.toMillis(120L);
    final InternalHandlerRegistry.Builder registryBuilder = new InternalHandlerRegistry.Builder();
    final List<ServerTransportFilter> transportFilters = new ArrayList<ServerTransportFilter>();
    final List<ServerInterceptor> interceptors = new ArrayList<ServerInterceptor>();
    private final List<InternalNotifyOnServerBuild> notifyOnBuildList = new ArrayList<InternalNotifyOnServerBuild>();
    private final List<ServerStreamTracer.Factory> streamTracerFactories = new ArrayList<ServerStreamTracer.Factory>();
    HandlerRegistry fallbackRegistry = DEFAULT_FALLBACK_REGISTRY;
    ObjectPool<? extends Executor> executorPool = DEFAULT_EXECUTOR_POOL;
    DecompressorRegistry decompressorRegistry = DEFAULT_DECOMPRESSOR_REGISTRY;
    CompressorRegistry compressorRegistry = DEFAULT_COMPRESSOR_REGISTRY;
    long handshakeTimeoutMillis = DEFAULT_HANDSHAKE_TIMEOUT_MILLIS;
    Deadline.Ticker ticker = Deadline.getSystemTicker();
    @Nullable
    private CensusStatsModule censusStatsOverride;
    private boolean statsEnabled = true;
    private boolean recordStartedRpcs = true;
    private boolean recordFinishedRpcs = true;
    private boolean recordRealTimeMetrics = false;
    private boolean tracingEnabled = true;
    @Nullable
    BinaryLog binlog;
    TransportTracer.Factory transportTracerFactory = TransportTracer.getDefaultFactory();
    InternalChannelz channelz = InternalChannelz.instance();
    CallTracer.Factory callTracerFactory = CallTracer.getDefaultFactory();

    public static ServerBuilder<?> forPort(int port) {
        throw new UnsupportedOperationException("Subclass failed to hide static factory");
    }

    @Override
    public final T directExecutor() {
        return (T)this.executor(MoreExecutors.directExecutor());
    }

    @Override
    public final T executor(@Nullable Executor executor) {
        this.executorPool = executor != null ? new FixedObjectPool<Executor>(executor) : DEFAULT_EXECUTOR_POOL;
        return this.thisT();
    }

    @Override
    public final T addService(ServerServiceDefinition service) {
        this.registryBuilder.addService(Preconditions.checkNotNull(service, "service"));
        return this.thisT();
    }

    @Override
    public final T addService(BindableService bindableService) {
        if (bindableService instanceof InternalNotifyOnServerBuild) {
            this.notifyOnBuildList.add((InternalNotifyOnServerBuild)((Object)bindableService));
        }
        return (T)this.addService(Preconditions.checkNotNull(bindableService, "bindableService").bindService());
    }

    @Override
    public final T addTransportFilter(ServerTransportFilter filter) {
        this.transportFilters.add(Preconditions.checkNotNull(filter, "filter"));
        return this.thisT();
    }

    @Override
    public final T intercept(ServerInterceptor interceptor) {
        this.interceptors.add(Preconditions.checkNotNull(interceptor, "interceptor"));
        return this.thisT();
    }

    @Override
    public final T addStreamTracerFactory(ServerStreamTracer.Factory factory) {
        this.streamTracerFactories.add(Preconditions.checkNotNull(factory, "factory"));
        return this.thisT();
    }

    @Override
    public final T fallbackHandlerRegistry(@Nullable HandlerRegistry registry) {
        this.fallbackRegistry = registry != null ? registry : DEFAULT_FALLBACK_REGISTRY;
        return this.thisT();
    }

    @Override
    public final T decompressorRegistry(@Nullable DecompressorRegistry registry) {
        this.decompressorRegistry = registry != null ? registry : DEFAULT_DECOMPRESSOR_REGISTRY;
        return this.thisT();
    }

    @Override
    public final T compressorRegistry(@Nullable CompressorRegistry registry) {
        this.compressorRegistry = registry != null ? registry : DEFAULT_COMPRESSOR_REGISTRY;
        return this.thisT();
    }

    @Override
    public final T handshakeTimeout(long timeout, TimeUnit unit) {
        Preconditions.checkArgument(timeout > 0L, "handshake timeout is %s, but must be positive", timeout);
        this.handshakeTimeoutMillis = Preconditions.checkNotNull(unit, "unit").toMillis(timeout);
        return this.thisT();
    }

    @Override
    public final T setBinaryLog(@Nullable BinaryLog binaryLog) {
        this.binlog = binaryLog;
        return this.thisT();
    }

    @VisibleForTesting
    protected final T overrideCensusStatsModule(@Nullable CensusStatsModule censusStats) {
        this.censusStatsOverride = censusStats;
        return this.thisT();
    }

    @VisibleForTesting
    public final T setTransportTracerFactory(TransportTracer.Factory transportTracerFactory) {
        this.transportTracerFactory = transportTracerFactory;
        return this.thisT();
    }

    protected void setStatsEnabled(boolean value) {
        this.statsEnabled = value;
    }

    protected void setStatsRecordStartedRpcs(boolean value) {
        this.recordStartedRpcs = value;
    }

    protected void setStatsRecordFinishedRpcs(boolean value) {
        this.recordFinishedRpcs = value;
    }

    protected void setStatsRecordRealTimeMetrics(boolean value) {
        this.recordRealTimeMetrics = value;
    }

    protected void setTracingEnabled(boolean value) {
        this.tracingEnabled = value;
    }

    protected void setDeadlineTicker(Deadline.Ticker ticker) {
        this.ticker = Preconditions.checkNotNull(ticker, "ticker");
    }

    @Override
    public final Server build() {
        ServerImpl server = new ServerImpl(this, this.buildTransportServers(this.getTracerFactories()), Context.ROOT);
        for (InternalNotifyOnServerBuild notifyTarget : this.notifyOnBuildList) {
            notifyTarget.notifyOnBuild(server);
        }
        return server;
    }

    @VisibleForTesting
    final List<? extends ServerStreamTracer.Factory> getTracerFactories() {
        ArrayList<ServerStreamTracer.Factory> tracerFactories = new ArrayList<ServerStreamTracer.Factory>();
        if (this.statsEnabled) {
            CensusStatsModule censusStats = this.censusStatsOverride;
            if (censusStats == null) {
                censusStats = new CensusStatsModule(GrpcUtil.STOPWATCH_SUPPLIER, true, this.recordStartedRpcs, this.recordFinishedRpcs, this.recordRealTimeMetrics);
            }
            tracerFactories.add(censusStats.getServerTracerFactory());
        }
        if (this.tracingEnabled) {
            CensusTracingModule censusTracing = new CensusTracingModule(Tracing.getTracer(), Tracing.getPropagationComponent().getBinaryFormat());
            tracerFactories.add(censusTracing.getServerTracerFactory());
        }
        tracerFactories.addAll(this.streamTracerFactories);
        tracerFactories.trimToSize();
        return Collections.unmodifiableList(tracerFactories);
    }

    protected final InternalChannelz getChannelz() {
        return this.channelz;
    }

    protected final TransportTracer.Factory getTransportTracerFactory() {
        return this.transportTracerFactory;
    }

    protected abstract List<? extends InternalServer> buildTransportServers(List<? extends ServerStreamTracer.Factory> var1);

    private T thisT() {
        AbstractServerImplBuilder thisT = this;
        return (T)thisT;
    }

    private static final class DefaultFallbackRegistry
    extends HandlerRegistry {
        private DefaultFallbackRegistry() {
        }

        @Override
        public List<ServerServiceDefinition> getServices() {
            return Collections.emptyList();
        }

        @Override
        @Nullable
        public ServerMethodDefinition<?, ?> lookupMethod(String methodName, @Nullable String authority) {
            return null;
        }
    }
}

