/*
 * Decompiled with CFR 0.152.
 */
package io.shaded.netty.handler.codec.string;

import io.shaded.netty.buffer.ByteBufUtil;
import io.shaded.netty.channel.ChannelHandler;
import io.shaded.netty.channel.ChannelHandlerContext;
import io.shaded.netty.handler.codec.MessageToMessageEncoder;
import io.shaded.netty.util.internal.ObjectUtil;
import java.nio.CharBuffer;
import java.nio.charset.Charset;
import java.util.List;

@ChannelHandler.Sharable
public class StringEncoder
extends MessageToMessageEncoder<CharSequence> {
    private final Charset charset;

    public StringEncoder() {
        this(Charset.defaultCharset());
    }

    public StringEncoder(Charset charset) {
        this.charset = ObjectUtil.checkNotNull(charset, "charset");
    }

    @Override
    protected void encode(ChannelHandlerContext ctx, CharSequence msg, List<Object> out) throws Exception {
        if (msg.length() == 0) {
            return;
        }
        out.add(ByteBufUtil.encodeString(ctx.alloc(), CharBuffer.wrap(msg), this.charset));
    }
}

