/*
 * Decompiled with CFR 0.152.
 */
package io.shaded.grpc.internal;

import com.shaded.google.common.annotations.VisibleForTesting;
import com.shaded.google.common.base.Preconditions;
import com.shaded.google.common.util.concurrent.ListenableFuture;
import com.shaded.google.common.util.concurrent.SettableFuture;
import io.shaded.grpc.CallOptions;
import io.shaded.grpc.ClientStreamTracer;
import io.shaded.grpc.InternalChannelz;
import io.shaded.grpc.InternalLogId;
import io.shaded.grpc.Metadata;
import io.shaded.grpc.MethodDescriptor;
import io.shaded.grpc.Status;
import io.shaded.grpc.internal.ClientStream;
import io.shaded.grpc.internal.ClientStreamListener;
import io.shaded.grpc.internal.ClientTransport;
import io.shaded.grpc.internal.FailingClientStream;
import java.util.concurrent.Executor;

class FailingClientTransport
implements ClientTransport {
    @VisibleForTesting
    final Status error;
    private final ClientStreamListener.RpcProgress rpcProgress;

    FailingClientTransport(Status error, ClientStreamListener.RpcProgress rpcProgress) {
        Preconditions.checkArgument(!error.isOk(), "error must not be OK");
        this.error = error;
        this.rpcProgress = rpcProgress;
    }

    @Override
    public ClientStream newStream(MethodDescriptor<?, ?> method, Metadata headers, CallOptions callOptions, ClientStreamTracer[] tracers) {
        return new FailingClientStream(this.error, this.rpcProgress, tracers);
    }

    @Override
    public void ping(final ClientTransport.PingCallback callback, Executor executor) {
        executor.execute(new Runnable(){

            @Override
            public void run() {
                callback.onFailure(FailingClientTransport.this.error.asException());
            }
        });
    }

    @Override
    public ListenableFuture<InternalChannelz.SocketStats> getStats() {
        SettableFuture<InternalChannelz.SocketStats> ret = SettableFuture.create();
        ret.set(null);
        return ret;
    }

    @Override
    public InternalLogId getLogId() {
        throw new UnsupportedOperationException("Not a real transport");
    }
}

