/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.core;

import io.vertx.codegen.annotations.Fluent;
import io.vertx.codegen.annotations.GenIgnore;
import io.vertx.codegen.annotations.Nullable;
import io.vertx.codegen.annotations.VertxGen;
import io.vertx.core.AsyncResult;
import io.vertx.core.Future;
import io.vertx.core.Handler;
import io.vertx.core.Promise;
import io.vertx.core.Vertx;
import io.vertx.core.impl.VertxThread;
import io.vertx.core.impl.launcher.VertxCommandLauncher;
import io.vertx.core.json.JsonObject;
import java.util.List;

@VertxGen
public interface Context {
    public static boolean isOnWorkerThread() {
        Thread t2 = Thread.currentThread();
        return t2 instanceof VertxThread && ((VertxThread)t2).isWorker();
    }

    public static boolean isOnEventLoopThread() {
        Thread t2 = Thread.currentThread();
        return t2 instanceof VertxThread && !((VertxThread)t2).isWorker();
    }

    public static boolean isOnVertxThread() {
        return Thread.currentThread() instanceof VertxThread;
    }

    public void runOnContext(Handler<Void> var1);

    public <T> void executeBlocking(Handler<Promise<T>> var1, boolean var2, Handler<AsyncResult<@Nullable T>> var3);

    default public <T> void executeBlocking(Handler<Promise<T>> blockingCodeHandler, Handler<AsyncResult<@Nullable T>> resultHandler) {
        this.executeBlocking(blockingCodeHandler, true, resultHandler);
    }

    public <T> Future<@Nullable T> executeBlocking(Handler<Promise<T>> var1, boolean var2);

    default public <T> Future<T> executeBlocking(Handler<Promise<T>> blockingCodeHandler) {
        return this.executeBlocking(blockingCodeHandler, true);
    }

    public String deploymentID();

    public @Nullable JsonObject config();

    default public List<String> processArgs() {
        return VertxCommandLauncher.getProcessArguments();
    }

    public boolean isEventLoopContext();

    public boolean isWorkerContext();

    public <T> T get(Object var1);

    public void put(Object var1, Object var2);

    public boolean remove(Object var1);

    public <T> T getLocal(Object var1);

    public void putLocal(Object var1, Object var2);

    public boolean removeLocal(Object var1);

    public Vertx owner();

    public int getInstanceCount();

    @Fluent
    public Context exceptionHandler(@Nullable Handler<Throwable> var1);

    @GenIgnore
    public @Nullable Handler<Throwable> exceptionHandler();
}

