/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.core;

import io.vertx.codegen.annotations.DataObject;
import io.vertx.core.DeploymentOptionsConverter;
import io.vertx.core.VertxOptions;
import io.vertx.core.json.JsonObject;
import java.util.concurrent.TimeUnit;

@DataObject(generateConverter=true, publicConverter=false)
public class DeploymentOptions {
    public static final boolean DEFAULT_WORKER = false;
    public static final boolean DEFAULT_HA = false;
    public static final int DEFAULT_INSTANCES = 1;
    private JsonObject config;
    private boolean worker;
    private String workerPoolName;
    private int workerPoolSize;
    private long maxWorkerExecuteTime;
    private boolean ha;
    private int instances;
    private TimeUnit maxWorkerExecuteTimeUnit;
    private ClassLoader classLoader;

    public DeploymentOptions() {
        this.worker = false;
        this.config = null;
        this.ha = false;
        this.instances = 1;
        this.workerPoolName = null;
        this.workerPoolSize = 20;
        this.maxWorkerExecuteTime = VertxOptions.DEFAULT_MAX_WORKER_EXECUTE_TIME;
        this.maxWorkerExecuteTimeUnit = VertxOptions.DEFAULT_MAX_WORKER_EXECUTE_TIME_UNIT;
    }

    public DeploymentOptions(DeploymentOptions other) {
        this.config = other.getConfig() == null ? null : other.getConfig().copy();
        this.worker = other.isWorker();
        this.ha = other.isHa();
        this.instances = other.instances;
        this.workerPoolName = other.workerPoolName;
        this.setWorkerPoolSize(other.workerPoolSize);
        this.setMaxWorkerExecuteTime(other.maxWorkerExecuteTime);
        this.maxWorkerExecuteTimeUnit = other.maxWorkerExecuteTimeUnit;
    }

    public DeploymentOptions(JsonObject json) {
        this();
        DeploymentOptionsConverter.fromJson(json, this);
    }

    public void fromJson(JsonObject json) {
        this.config = json.getJsonObject("config");
        this.worker = json.getBoolean("worker", false);
        this.ha = json.getBoolean("ha", false);
        this.instances = json.getInteger("instances", 1);
    }

    public JsonObject getConfig() {
        return this.config;
    }

    public DeploymentOptions setConfig(JsonObject config) {
        this.config = config;
        return this;
    }

    public boolean isWorker() {
        return this.worker;
    }

    public DeploymentOptions setWorker(boolean worker) {
        this.worker = worker;
        return this;
    }

    public boolean isHa() {
        return this.ha;
    }

    public DeploymentOptions setHa(boolean ha) {
        this.ha = ha;
        return this;
    }

    public int getInstances() {
        return this.instances;
    }

    public DeploymentOptions setInstances(int instances) {
        this.instances = instances;
        return this;
    }

    public String getWorkerPoolName() {
        return this.workerPoolName;
    }

    public DeploymentOptions setWorkerPoolName(String workerPoolName) {
        this.workerPoolName = workerPoolName;
        return this;
    }

    public int getWorkerPoolSize() {
        return this.workerPoolSize;
    }

    public DeploymentOptions setWorkerPoolSize(int workerPoolSize) {
        if (workerPoolSize < 1) {
            throw new IllegalArgumentException("workerPoolSize must be > 0");
        }
        this.workerPoolSize = workerPoolSize;
        return this;
    }

    public long getMaxWorkerExecuteTime() {
        return this.maxWorkerExecuteTime;
    }

    public DeploymentOptions setMaxWorkerExecuteTime(long maxWorkerExecuteTime) {
        if (maxWorkerExecuteTime < 1L) {
            throw new IllegalArgumentException("maxWorkerExecuteTime must be > 0");
        }
        this.maxWorkerExecuteTime = maxWorkerExecuteTime;
        return this;
    }

    public TimeUnit getMaxWorkerExecuteTimeUnit() {
        return this.maxWorkerExecuteTimeUnit;
    }

    public DeploymentOptions setMaxWorkerExecuteTimeUnit(TimeUnit maxWorkerExecuteTimeUnit) {
        this.maxWorkerExecuteTimeUnit = maxWorkerExecuteTimeUnit;
        return this;
    }

    public ClassLoader getClassLoader() {
        return this.classLoader;
    }

    public DeploymentOptions setClassLoader(ClassLoader classLoader) {
        this.classLoader = classLoader;
        return this;
    }

    public void checkIsolationNotDefined() {
    }

    public JsonObject toJson() {
        JsonObject json = new JsonObject();
        DeploymentOptionsConverter.toJson(this, json);
        return json;
    }
}

