/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.core.http.impl;

import io.shaded.netty.buffer.ByteBuf;
import io.shaded.netty.channel.ChannelHandlerContext;
import io.shaded.netty.channel.ChannelPromise;
import io.shaded.netty.handler.codec.compression.CompressionOptions;
import io.shaded.netty.handler.codec.http.DefaultHttpContent;
import io.shaded.netty.handler.codec.http.HttpContentCompressor;
import io.shaded.netty.handler.codec.http.HttpContentEncoder;
import io.shaded.netty.handler.codec.http.HttpHeaderNames;
import io.shaded.netty.handler.codec.http.HttpResponse;

final class HttpChunkContentCompressor
extends HttpContentCompressor {
    public HttpChunkContentCompressor(CompressionOptions ... compressionOptions) {
        super(0, compressionOptions);
    }

    @Override
    public void write(ChannelHandlerContext ctx, Object msg, ChannelPromise promise) throws Exception {
        ByteBuf buff;
        if (msg instanceof ByteBuf && (buff = (ByteBuf)msg).isReadable()) {
            msg = new DefaultHttpContent(buff);
        }
        super.write(ctx, msg, promise);
    }

    @Override
    protected HttpContentEncoder.Result beginEncode(HttpResponse httpResponse, String acceptEncoding) throws Exception {
        HttpContentEncoder.Result result = super.beginEncode(httpResponse, acceptEncoding);
        if (result == null && httpResponse.headers().contains(HttpHeaderNames.CONTENT_ENCODING, (CharSequence)"identity", true)) {
            httpResponse.headers().remove(HttpHeaderNames.CONTENT_ENCODING);
        }
        return result;
    }
}

