/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.grpc;

import io.shaded.grpc.Metadata;
import io.shaded.grpc.ServerCall;
import io.shaded.grpc.ServerCallHandler;
import io.shaded.grpc.ServerInterceptor;
import io.shaded.grpc.Status;
import io.vertx.core.Vertx;
import java.util.LinkedList;
import java.util.List;
import java.util.function.Consumer;

public class BlockingServerInterceptor
implements ServerInterceptor {
    private final Vertx vertx;
    private final ServerInterceptor interceptor;

    public static ServerInterceptor wrap(Vertx vertx, ServerInterceptor interceptor) {
        return new BlockingServerInterceptor(vertx, interceptor);
    }

    private BlockingServerInterceptor(Vertx vertx, ServerInterceptor interceptor) {
        this.vertx = vertx;
        this.interceptor = interceptor;
    }

    @Override
    public <ReqT, RespT> ServerCall.Listener<ReqT> interceptCall(ServerCall<ReqT, RespT> serverCall, Metadata metadata, ServerCallHandler<ReqT, RespT> serverCallHandler) {
        AsyncListener asyncListener = new AsyncListener();
        this.vertx.executeBlocking(blockingCode -> blockingCode.complete(this.interceptor.interceptCall(serverCall, metadata, serverCallHandler)), false, ar -> {
            if (ar.succeeded()) {
                asyncListener.setDelegate((ServerCall.Listener)ar.result());
            } else {
                Metadata md = Status.trailersFromThrowable(ar.cause());
                if (md == null) {
                    md = new Metadata();
                }
                serverCall.close(Status.fromThrowable(ar.cause()), md);
            }
        });
        return asyncListener;
    }

    private static class AsyncListener<ReqT>
    extends ServerCall.Listener<ReqT> {
        private ServerCall.Listener<ReqT> delegate;
        private final List<Consumer<ServerCall.Listener<ReqT>>> incomingEvents = new LinkedList<Consumer<ServerCall.Listener<ReqT>>>();

        private AsyncListener() {
        }

        void setDelegate(ServerCall.Listener<ReqT> delegate) {
            this.delegate = delegate;
            for (Consumer<ServerCall.Listener<ReqT>> event : this.incomingEvents) {
                event.accept(delegate);
            }
            this.incomingEvents.clear();
        }

        private void runIfPresent(Consumer<ServerCall.Listener<ReqT>> consumer) {
            if (this.delegate != null) {
                consumer.accept(this.delegate);
            } else {
                this.incomingEvents.add(consumer);
            }
        }

        @Override
        public void onMessage(ReqT message) {
            this.runIfPresent(t2 -> t2.onMessage(message));
        }

        @Override
        public void onHalfClose() {
            this.runIfPresent(ServerCall.Listener::onHalfClose);
        }

        @Override
        public void onCancel() {
            this.runIfPresent(ServerCall.Listener::onCancel);
        }

        @Override
        public void onComplete() {
            this.runIfPresent(ServerCall.Listener::onComplete);
        }

        @Override
        public void onReady() {
            this.runIfPresent(ServerCall.Listener::onReady);
        }
    }
}

