/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.grpc;

import io.shaded.grpc.Server;
import io.shaded.grpc.netty.NettyServerBuilder;
import io.vertx.core.AsyncResult;
import io.vertx.core.Closeable;
import io.vertx.core.Future;
import io.vertx.core.Handler;
import io.vertx.core.Promise;
import io.vertx.core.VertxException;
import io.vertx.core.http.HttpServerOptions;
import io.vertx.core.http.HttpVersion;
import io.vertx.core.impl.ContextInternal;
import io.vertx.core.impl.VertxInternal;
import io.vertx.core.impl.WorkerContext;
import io.vertx.core.impl.future.PromiseInternal;
import io.vertx.core.net.impl.SSLHelper;
import io.vertx.core.net.impl.ServerID;
import io.vertx.core.net.impl.SslContextProvider;
import io.vertx.core.net.impl.VertxEventLoopGroup;
import io.vertx.core.net.impl.VertxSslContext;
import io.vertx.core.spi.transport.Transport;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Executor;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.function.Consumer;

public class VertxServer
extends Server {
    private static final ConcurrentMap<ServerID, ActualServer> map = new ConcurrentHashMap<ServerID, ActualServer>();
    private final ServerID id;
    private final NettyServerBuilder builder;
    private final HttpServerOptions options;
    private ActualServer actual;
    private final ContextInternal context;
    private final Consumer<Runnable> commandDecorator;
    private Closeable hook;

    VertxServer(ServerID id, HttpServerOptions options, NettyServerBuilder builder, ContextInternal context, Consumer<Runnable> commandDecorator) {
        this.id = id;
        this.options = options;
        this.builder = builder;
        this.context = context;
        this.commandDecorator = commandDecorator;
    }

    @Override
    public VertxServer start() throws IOException {
        return this.start(ar -> {});
    }

    public VertxServer start(Handler<AsyncResult<Void>> completionHandler) {
        this.actual = this.id.port > 0 ? map.computeIfAbsent(this.id, id -> new ActualServer(this.context.owner(), (ServerID)id, this.options, this.builder, this.commandDecorator)) : new ActualServer(this.context.owner(), this.id, this.options, this.builder, this.commandDecorator);
        this.actual.start(this.context, ar1 -> {
            if (ar1.succeeded()) {
                this.hook = this::shutdown;
                this.context.addCloseHook(this.hook);
            }
            completionHandler.handle((AsyncResult<Void>)ar1);
        });
        return this;
    }

    @Override
    public VertxServer shutdown() {
        return this.shutdown(ar -> {});
    }

    public VertxServer shutdown(Handler<AsyncResult<Void>> completionHandler) {
        if (this.hook != null) {
            this.context.removeCloseHook(this.hook);
        }
        PromiseInternal<Void> promise = this.context.promise(completionHandler);
        this.actual.stop(this.context, promise);
        return this;
    }

    @Override
    public int getPort() {
        return this.actual.server.getPort();
    }

    @Override
    public VertxServer shutdownNow() {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean isShutdown() {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean isTerminated() {
        return this.actual.server.isTerminated();
    }

    @Override
    public boolean awaitTermination(long timeout, TimeUnit unit) throws InterruptedException {
        return this.actual.server.awaitTermination(timeout, unit);
    }

    @Override
    public void awaitTermination() throws InterruptedException {
        this.actual.server.awaitTermination();
    }

    public Server getRawServer() {
        return this.actual.server;
    }

    private static class ActualServer {
        final ServerID id;
        final HttpServerOptions options;
        final AtomicInteger count = new AtomicInteger();
        final VertxEventLoopGroup group = new VertxEventLoopGroup();
        final Server server;
        final ThreadLocal<List<ContextInternal>> contextLocal = new ThreadLocal();

        private ActualServer(VertxInternal vertx, ServerID id, HttpServerOptions options, NettyServerBuilder builder, Consumer<Runnable> commandDecorator) {
            if (options.isSsl()) {
                SslContextProvider provider;
                WorkerContext other = vertx.createWorkerContext();
                try {
                    SSLHelper helper = new SSLHelper(options, Collections.singletonList(HttpVersion.HTTP_2.alpnName()));
                    provider = helper.buildContextProvider(options.getSslOptions(), other).toCompletionStage().toCompletableFuture().get(1L, TimeUnit.MINUTES);
                }
                catch (InterruptedException e) {
                    throw new VertxException(e);
                }
                catch (ExecutionException e) {
                    throw new VertxException(e.getCause());
                }
                catch (TimeoutException e) {
                    throw new VertxException(e);
                }
                VertxSslContext ctx = provider.createServerContext(true);
                builder.sslContext(ctx);
            }
            Transport transport = vertx.transport();
            this.id = id;
            this.options = options;
            Executor executor = commandDecorator == null ? command -> this.contextLocal.get().get(0).runOnContext(event -> command.run()) : command -> this.contextLocal.get().get(0).runOnContext(event -> commandDecorator.accept(command));
            this.server = ((NettyServerBuilder)builder.executor(executor)).channelFactory(transport.serverChannelFactory(false)).bossEventLoopGroup(vertx.getAcceptorEventLoopGroup()).workerEventLoopGroup(this.group).build();
        }

        void start(ContextInternal context, Handler<AsyncResult<Void>> completionHandler) {
            boolean start = this.count.getAndIncrement() == 0;
            context.runOnContext(v -> {
                if (this.contextLocal.get() == null) {
                    this.contextLocal.set(new ArrayList());
                }
                this.group.addWorker(context.nettyEventLoop());
                this.contextLocal.get().add(context);
                if (start) {
                    context.executeBlocking(v2 -> {
                        try {
                            this.server.start();
                            v2.complete();
                        }
                        catch (IOException e) {
                            v2.fail(e);
                        }
                    }, completionHandler);
                } else {
                    completionHandler.handle(Future.succeededFuture());
                }
            });
        }

        void stop(ContextInternal context, Promise<Void> promise) {
            boolean shutdown = this.count.decrementAndGet() == 0;
            context.runOnContext(v -> {
                this.group.removeWorker(context.nettyEventLoop());
                this.contextLocal.get().remove(context);
                if (shutdown) {
                    map.remove(this.id);
                    context.executeBlocking(p -> {
                        this.server.shutdown();
                        p.complete();
                    }, promise);
                } else {
                    promise.complete();
                }
            });
        }
    }
}

